/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.bean;

import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.perfectable.introspection.bean.Property;
import org.perfectable.introspection.type.TypeView;

public abstract class PropertySchema<B, T> {
    public abstract String name();

    public abstract Type type();

    public abstract boolean isReadable();

    public abstract boolean isWritable();

    final Property<B, T> bind(B bean) {
        return Property.of(bean, this);
    }

    PropertySchema() {
    }

    abstract T get(B var1);

    abstract void set(B var1, @Nullable T var2);

    final <X extends T> PropertySchema<B, X> as(Class<X> propertyClass) {
        Preconditions.checkArgument((boolean)TypeView.of(this.type()).isSuperTypeOf(propertyClass));
        PropertySchema casted = this;
        return casted;
    }
}

