/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.proxy;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.perfectable.introspection.proxy.Invocation;

final class Invocations {
    private Invocations() {
    }

    static final class RunnableAdapter
    implements Invocation {
        private final Runnable runnable;

        RunnableAdapter(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        @Nullable
        public Object invoke() {
            this.runnable.run();
            return null;
        }
    }

    static final class CallableAdapter
    implements Invocation {
        private final Callable<?> callable;

        CallableAdapter(Callable<?> callable) {
            this.callable = callable;
        }

        @Override
        @Nullable
        public Object invoke() throws Throwable {
            return this.callable.call();
        }
    }

    static final class Throwing
    implements Invocation {
        private final Supplier<Throwable> thrownSupplier;

        Throwing(Supplier<Throwable> thrownSupplier) {
            this.thrownSupplier = thrownSupplier;
        }

        @Override
        @Nullable
        @CanIgnoreReturnValue
        public Object invoke() throws Throwable {
            Throwable thrown = this.thrownSupplier.get();
            throw thrown;
        }
    }

    static final class Returning
    implements Invocation {
        @Nullable
        private final Object result;

        Returning(@Nullable Object result) {
            this.result = result;
        }

        @Override
        @Nullable
        public Object invoke() {
            return this.result;
        }
    }
}

