/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.proxy;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import javax.annotation.Nullable;
import org.objenesis.ObjenesisStd;
import org.perfectable.introspection.ObjectMethods;
import org.perfectable.introspection.proxy.InvocationHandler;
import org.perfectable.introspection.proxy.MethodInvocation;
import org.perfectable.introspection.proxy.ProxyService;

@Immutable
public final class JavassistProxyService
implements ProxyService {
    private static final ObjenesisStd OBJENESIS = new ObjenesisStd();
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<ProxyService.Feature> SUPPORTED_FEATURES = EnumSet.of(ProxyService.Feature.SUPERCLASS);

    @Override
    public boolean supportsFeature(ProxyService.Feature feature) {
        return SUPPORTED_FEATURES.contains((Object)feature);
    }

    @Override
    public <I> I instantiate(ClassLoader classLoader, Class<?> baseClass, List<? extends Class<?>> interfaces, InvocationHandler<? super MethodInvocation<I>> handler) throws ProxyService.UnsupportedFeatureException {
        Preconditions.checkArgument((!Modifier.isFinal(baseClass.getModifiers()) ? 1 : 0) != 0);
        Class<I> proxyClass = JavassistProxyService.createProxyClass(baseClass, interfaces);
        return JavassistProxyService.instantiateProxyClass(proxyClass, handler);
    }

    private static <I> Class<I> createProxyClass(Class<?> baseClass, List<? extends Class<?>> interfaces) {
        if (ProxyFactory.isProxyClass(baseClass) && interfaces.stream().allMatch(testedInterface -> testedInterface.isAssignableFrom(baseClass))) {
            return baseClass;
        }
        ProxyFactory factory = new ProxyFactory();
        if (!baseClass.getName().equals(Object.class.getName())) {
            factory.setSuperclass(baseClass);
        }
        Class[] interfacesArray = interfaces.toArray(EMPTY_CLASS_ARRAY);
        factory.setInterfaces(interfacesArray);
        return factory.createClass();
    }

    private static <I> I instantiateProxyClass(Class<I> proxyClass, InvocationHandler<? super MethodInvocation<I>> handler) {
        JavassistInvocationHandlerAdapter handlerAdapter = JavassistInvocationHandlerAdapter.adapt(handler);
        Object proxy = OBJENESIS.newInstance(proxyClass);
        ((Proxy)proxy).setHandler(handlerAdapter);
        return (I)proxy;
    }

    private static final class JavassistInvocationHandlerAdapter<T>
    implements MethodHandler {
        private final InvocationHandler<? super MethodInvocation<T>> handler;

        static <X> JavassistInvocationHandlerAdapter<X> adapt(InvocationHandler<? super MethodInvocation<X>> handler) {
            return new JavassistInvocationHandlerAdapter(handler);
        }

        private JavassistInvocationHandlerAdapter(InvocationHandler<? super MethodInvocation<T>> handler) {
            this.handler = handler;
        }

        @Nullable
        public Object invoke(@Nullable Object self, Method thisMethod, Method proceed, @Nullable Object[] args) throws Throwable {
            Objects.requireNonNull(thisMethod);
            if (thisMethod.equals(ObjectMethods.FINALIZE)) {
                return null;
            }
            Object castedSelf = self;
            MethodInvocation<Object> invocation = MethodInvocation.intercepted(thisMethod, castedSelf, args);
            return this.handler.handle(invocation);
        }
    }
}

