/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.proxy;

import com.google.errorprone.annotations.Immutable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.perfectable.introspection.ObjectMethods;
import org.perfectable.introspection.proxy.InvocationHandler;
import org.perfectable.introspection.proxy.MethodInvocation;
import org.perfectable.introspection.proxy.ProxyService;

@Immutable
public final class JdkProxyService
implements ProxyService {
    private static final Set<ProxyService.Feature> SUPPORTED_FEATURES = EnumSet.noneOf(ProxyService.Feature.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    @Override
    public boolean supportsFeature(ProxyService.Feature feature) {
        return SUPPORTED_FEATURES.contains((Object)feature);
    }

    @Override
    public <I> I instantiate(ClassLoader classLoader, Class<?> baseClass, List<? extends Class<?>> interfaces, InvocationHandler<? super MethodInvocation<I>> handler) throws ProxyService.UnsupportedFeatureException {
        if (!baseClass.getName().equals(Object.class.getName())) {
            throw new ProxyService.UnsupportedFeatureException("JDK proxy cannot be created with superclass other than Object");
        }
        JdkInvocationHandlerAdapter adapterHandler = JdkInvocationHandlerAdapter.adapt(handler);
        Class<?>[] interfacesArray = interfaces.toArray(EMPTY_CLASS_ARRAY);
        try {
            Object instance = Proxy.newProxyInstance(classLoader, interfacesArray, adapterHandler);
            return (I)instance;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError("Proxy construction failed", e);
        }
    }

    private static final class JdkInvocationHandlerAdapter<T>
    implements java.lang.reflect.InvocationHandler {
        private final InvocationHandler<? super MethodInvocation<T>> handler;

        static <T> JdkInvocationHandlerAdapter<T> adapt(InvocationHandler<? super MethodInvocation<T>> handler) {
            return new JdkInvocationHandlerAdapter<T>(handler);
        }

        private JdkInvocationHandlerAdapter(InvocationHandler<? super MethodInvocation<T>> handler) {
            this.handler = handler;
        }

        @Override
        @Nullable
        public Object invoke(@Nullable Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            Objects.requireNonNull(method);
            if (method.equals(ObjectMethods.FINALIZE)) {
                return null;
            }
            Object castedProxy = proxy;
            MethodInvocation<Object> invocation = MethodInvocation.intercepted(method, castedProxy, args);
            return this.handler.handle(invocation);
        }
    }
}

