/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.proxy;

import com.google.errorprone.annotations.concurrent.LazyInit;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;
import org.perfectable.introspection.Introspections;
import org.perfectable.introspection.proxy.Invocation;
import org.perfectable.introspection.proxy.InvocationHandler;
import org.perfectable.introspection.proxy.MethodInvocation;
import org.perfectable.introspection.proxy.ProxyBuilder;
import org.perfectable.introspection.query.MethodQuery;

public final class LazyInitialization {
    public static <T> T createProxy(Class<T> resultClass, Initializer<? extends T> initializer) {
        LazyInitializationHandler<? extends T> handler = LazyInitializationHandler.create(initializer);
        return ProxyBuilder.forType(resultClass).withInterface(Proxy.class).instantiate(handler);
    }

    private LazyInitialization() {
    }

    private static final class LazyInitializationHandler<T>
    implements InvocationHandler<MethodInvocation<T>> {
        private static final Method EXTRACT_INSTANCE_METHOD = (Method)((MethodQuery)Introspections.introspect(Proxy.class).methods().named("extractInstance").parameters(new Type[0])).unique();
        private final Initializer<? extends T> initializer;
        @LazyInit
        private transient T instance;

        public static <T> LazyInitializationHandler<T> create(Initializer<? extends T> initializer) {
            return new LazyInitializationHandler<T>(initializer);
        }

        private LazyInitializationHandler(Initializer<? extends T> initializer) {
            this.initializer = initializer;
        }

        @Override
        @Nullable
        public Object handle(MethodInvocation<T> invocation) throws Throwable {
            return invocation.decompose(this::replaceInvocation).invoke();
        }

        private Invocation replaceInvocation(Method method, @Nullable T receiver, Object ... arguments) {
            if (EXTRACT_INSTANCE_METHOD.equals(method)) {
                return () -> Optional.ofNullable(this.instance);
            }
            if (this.instance == null) {
                this.instance = this.initializer.initialize();
            }
            return MethodInvocation.of(method, this.instance, arguments);
        }
    }

    @FunctionalInterface
    public static interface Initializer<T> {
        public T initialize();
    }

    public static interface Proxy<T> {
        public Optional<T> extractInstance();
    }
}

