/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.proxy;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.perfectable.introspection.Introspections;
import org.perfectable.introspection.proxy.Invocation;
import org.perfectable.introspection.query.ConstructorQuery;

public final class MethodInvocation<T>
implements Invocation {
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private final Method method;
    @Nullable
    private final T receiver;
    private final Object[] arguments;
    @LazyInit
    private transient MethodHandle handle;
    private static final MethodHandle PRIVATE_LOOKUP_CONSTRUCTOR = MethodInvocation.findPrivateLookupConstructor();

    public static <T> MethodInvocation<T> intercepted(Method method, @Nullable T receiver, Object ... arguments) {
        Object[] actualArguments = MethodInvocation.flattenVariableArguments(method, arguments);
        return MethodInvocation.of(method, receiver, actualArguments);
    }

    public static <T> MethodInvocation<T> of(Method method, @Nullable T receiver, Object ... arguments) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(arguments);
        MethodInvocation.verifyCallability(method, receiver, arguments);
        Object[] argumentsClone = (Object[])arguments.clone();
        return new MethodInvocation<T>(method, receiver, argumentsClone);
    }

    private MethodInvocation(Method method, @Nullable T receiver, Object ... arguments) {
        this.method = method;
        this.receiver = receiver;
        this.arguments = arguments;
    }

    @Override
    @Nullable
    @CanIgnoreReturnValue
    public Object invoke() throws Throwable {
        if (this.handle == null) {
            this.handle = this.createHandle();
        }
        return this.handle.invoke();
    }

    @CanIgnoreReturnValue
    public <R> R decompose(Decomposer<? super T, R> decomposer) {
        return decomposer.decompose(this.method, this.receiver, (Object[])this.arguments.clone());
    }

    public MethodInvocation<T> withMethod(Method newMethod) {
        MethodInvocation.verifyReceiverCompatibility(newMethod, this.receiver);
        MethodInvocation.verifyArgumentsCompatibility(newMethod, this.arguments);
        return new MethodInvocation<T>(newMethod, this.receiver, this.arguments);
    }

    public <X extends T> MethodInvocation<X> withReceiver(X newReceiver) {
        MethodInvocation.verifyReceiverCompatibility(this.method, newReceiver);
        return new MethodInvocation<X>(this.method, newReceiver, this.arguments);
    }

    public MethodInvocation<T> withArguments(Object ... newArguments) {
        MethodInvocation.verifyArgumentsCompatibility(this.method, newArguments);
        return new MethodInvocation<T>(this.method, this.receiver, newArguments);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.receiver, Arrays.hashCode(this.arguments));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation other = (MethodInvocation)obj;
        return Objects.equals(this.method, other.method) && Objects.equals(this.receiver, other.receiver) && Arrays.equals(this.arguments, other.arguments);
    }

    private static void verifyCallability(Method method, @Nullable Object receiver, Object ... arguments) {
        MethodInvocation.verifyReceiverCompatibility(method, receiver);
        MethodInvocation.verifyArgumentsCompatibility(method, arguments);
    }

    private static void verifyReceiverCompatibility(Method method, @Nullable Object receiver) {
        if ((method.getModifiers() & 8) == 0) {
            Preconditions.checkArgument((receiver != null ? 1 : 0) != 0, (String)"Method %s is not static, got null as receiver", (Object)method);
            Class<?> requiredType = method.getDeclaringClass();
            Preconditions.checkArgument((boolean)requiredType.isInstance(receiver), (String)"Method %s requires %s as receiver, got %s", (Object)method, requiredType, (Object)receiver);
        } else {
            Preconditions.checkArgument((receiver == null ? 1 : 0) != 0, (String)"Method %s is static, got %s as receiver", (Object)method, (Object)receiver);
        }
    }

    private static void verifyArgumentsCompatibility(Method method, Object ... arguments) {
        Class<?>[] formals = method.getParameterTypes();
        boolean isVarArgs = method.isVarArgs();
        if (isVarArgs) {
            Preconditions.checkArgument((arguments.length >= formals.length - 1 ? 1 : 0) != 0, (String)"Method %s requires at least %s arguments, got %s", (Object)method, (Object)(formals.length - 1), (Object)arguments.length);
        } else {
            Preconditions.checkArgument((arguments.length == formals.length ? 1 : 0) != 0, (String)"Method %s requires %s arguments, got %s", (Object)method, (Object)formals.length, (Object)arguments.length);
        }
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> parameterType = isVarArgs && i >= formals.length - 1 ? formals[formals.length - 1].getComponentType() : formals[i];
            Object argument = arguments[i];
            if (argument == null) {
                Preconditions.checkArgument((!parameterType.isPrimitive() ? 1 : 0) != 0, (String)"Method %s has primitive %s as parameter %s, got null argument", (Object)method, parameterType, (Object)(i + 1));
                continue;
            }
            Class<?> argumentType = argument.getClass();
            Class wrappedParameterType = Primitives.wrap(parameterType);
            Preconditions.checkArgument((boolean)wrappedParameterType.isAssignableFrom(argumentType), (String)"Method %s takes %s as parameter %s, got %s as argument", (Object)method, (Object)wrappedParameterType, (Object)(i + 1), (Object)argument);
        }
    }

    private static Object[] flattenVariableArguments(Method method, @Nullable Object[] actuals) {
        if (actuals == null) {
            return EMPTY_ARGUMENTS;
        }
        if (!method.isVarArgs()) {
            return actuals;
        }
        Class<?>[] formals = method.getParameterTypes();
        Object variableActual = actuals[actuals.length - 1];
        int variableLength = Array.getLength(variableActual);
        int resultSize = formals.length - 1 + variableLength;
        Object[] result = new Object[resultSize];
        System.arraycopy(actuals, 0, result, 0, formals.length - 1);
        for (int i = 0; i < variableLength; ++i) {
            result[formals.length - 1 + i] = Array.get(variableActual, i);
        }
        return result;
    }

    private MethodHandle createHandle() {
        MethodHandle methodHandle;
        MethodHandles.Lookup lookup;
        try {
            lookup = PRIVATE_LOOKUP_CONSTRUCTOR.invoke(this.method.getDeclaringClass());
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
        try {
            methodHandle = lookup.unreflect(this.method);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        if (this.receiver != null) {
            methodHandle = methodHandle.bindTo(this.receiver);
        }
        if (this.method.isVarArgs()) {
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            Class<?> lastParameterType = parameterTypes[parameterTypes.length - 1];
            int overflowArguments = this.arguments.length - parameterTypes.length + 1;
            methodHandle = methodHandle.asCollector(lastParameterType, overflowArguments);
        }
        return MethodHandles.insertArguments(methodHandle, 0, this.arguments);
    }

    private static MethodHandle findPrivateLookupConstructor() {
        int allModifiers = 15;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ConstructorQuery<MethodHandles.Lookup> generalConstructorQuery = Introspections.introspect(MethodHandles.Lookup.class).constructors();
        Optional noPreviousClassConstructorOption = ((ConstructorQuery)generalConstructorQuery.parameters(new Type[]{Class.class, Integer.TYPE})).asAccessible().option();
        if (noPreviousClassConstructorOption.isPresent()) {
            MethodHandle methodHandle;
            Constructor lookupConstructor = (Constructor)noPreviousClassConstructorOption.get();
            try {
                methodHandle = lookup.unreflectConstructor(lookupConstructor);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            return MethodHandles.insertArguments(methodHandle, 1, allModifiers);
        }
        Optional withPreviousClassConstructorOption = ((ConstructorQuery)generalConstructorQuery.parameters(new Type[]{Class.class, Class.class, Integer.TYPE})).asAccessible().option();
        if (withPreviousClassConstructorOption.isPresent()) {
            MethodHandle methodHandle;
            Constructor lookupConstructor = (Constructor)withPreviousClassConstructorOption.get();
            try {
                methodHandle = lookup.unreflectConstructor(lookupConstructor);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            return MethodHandles.insertArguments(methodHandle, 1, null, allModifiers);
        }
        throw new AssertionError((Object)"Finding private lookup constructor was unsuccessful");
    }

    @FunctionalInterface
    public static interface Decomposer<T, R> {
        public R decompose(Method var1, @Nullable T var2, Object ... var3);
    }
}

