/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.lang.reflect.Modifier;
import java.util.List;
import org.perfectable.introspection.proxy.InvocationHandler;
import org.perfectable.introspection.proxy.MethodInvocation;
import org.perfectable.introspection.proxy.ProxyService;

@Immutable
public final class ProxyBuilder<I> {
    private final ClassLoader classLoader;
    private final Class<?> baseClass;
    private final ImmutableList<? extends Class<?>> interfaces;
    private final ProxyService service;

    private ProxyBuilder(ClassLoader classLoader, Class<?> baseClass, ImmutableList<? extends Class<?>> interfaces, ProxyService service) {
        this.classLoader = classLoader;
        this.baseClass = baseClass;
        this.interfaces = interfaces;
        this.service = service;
    }

    public static <X> ProxyBuilder<X> forClass(Class<X> superclass) {
        Preconditions.checkArgument((!superclass.isInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((!superclass.isPrimitive() ? 1 : 0) != 0);
        Preconditions.checkArgument((!Modifier.isFinal(superclass.getModifiers()) ? 1 : 0) != 0);
        ClassLoader classLoader = superclass.getClassLoader();
        ProxyService service = ProxyService.INSTANCES.get(ProxyService.Feature.SUPERCLASS);
        return new ProxyBuilder(classLoader, superclass, ImmutableList.of(), service);
    }

    public static <X> ProxyBuilder<X> forInterface(Class<X> baseInterface) {
        Preconditions.checkArgument((boolean)baseInterface.isInterface());
        ClassLoader classLoader = baseInterface.getClassLoader();
        ProxyService service = ProxyService.INSTANCES.get(new ProxyService.Feature[0]);
        return new ProxyBuilder(classLoader, Object.class, ImmutableList.of(baseInterface), service);
    }

    public static <X> ProxyBuilder<X> forType(Class<X> resultClass) {
        if (resultClass.isInterface()) {
            return ProxyBuilder.forInterface(resultClass);
        }
        return ProxyBuilder.forClass(resultClass);
    }

    public ProxyBuilder<I> withInterface(Class<?> additionalInterface) {
        Preconditions.checkArgument((boolean)additionalInterface.isInterface());
        Preconditions.checkArgument((boolean)this.classLoader.equals(additionalInterface.getClassLoader()));
        ImmutableList newInterfaces = ImmutableList.builder().addAll(this.interfaces).add(additionalInterface).build();
        return new ProxyBuilder<I>(this.classLoader, this.baseClass, newInterfaces, this.service);
    }

    public ProxyBuilder<I> usingService(ProxyService newService) {
        return new ProxyBuilder<I>(this.classLoader, this.baseClass, this.interfaces, newService);
    }

    public I instantiate(InvocationHandler<? super MethodInvocation<I>> handler) {
        return this.service.instantiate(this.classLoader, this.baseClass, (List<? extends Class<?>>)this.interfaces, handler);
    }
}

