/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.proxy;

import com.google.errorprone.annotations.Immutable;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.perfectable.introspection.proxy.InvocationHandler;
import org.perfectable.introspection.proxy.MethodInvocation;

@Immutable
public interface ProxyService {
    public static final Container INSTANCES = new Container();

    public boolean supportsFeature(Feature var1);

    default public boolean supportsAllFeatures(Feature ... features) {
        return Stream.of(features).allMatch(this::supportsFeature);
    }

    public <I> I instantiate(ClassLoader var1, Class<?> var2, List<? extends Class<?>> var3, InvocationHandler<? super MethodInvocation<I>> var4) throws UnsupportedFeatureException;

    public static final class Container {
        private final ServiceLoader<ProxyService> cache = ServiceLoader.load(ProxyService.class);

        public ProxyService get(Feature ... requiredFeatures) {
            for (ProxyService service : this.cache) {
                if (!service.supportsAllFeatures(requiredFeatures)) continue;
                return service;
            }
            throw new UnsupportedFeatureException("No proxy service supports " + Arrays.toString((Object[])requiredFeatures));
        }

        Container() {
        }
    }

    public static enum Feature {
        SUPERCLASS;

    }

    public static final class UnsupportedFeatureException
    extends RuntimeException {
        public UnsupportedFeatureException(String message) {
            super(message);
        }
    }
}

