/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import com.google.common.collect.Iterators;
import com.google.errorprone.annotations.CompatibleWith;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

abstract class AbstractQuery<E, Q extends AbstractQuery<E, ? extends Q>>
implements Iterable<E> {
    AbstractQuery() {
    }

    public abstract Q filter(Predicate<? super E> var1);

    public boolean contains(@CompatibleWith(value="E") Object candidate) {
        return Iterators.contains(this.iterator(), (Object)candidate);
    }

    public abstract Stream<E> stream();

    public final E unique() {
        return (E)Iterators.getOnlyElement(this.iterator());
    }

    public boolean isPresent() {
        return this.iterator().hasNext();
    }

    public final Optional<E> option() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        E element = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Multiple elements were present in the query");
        }
        return Optional.of(element);
    }

    @Override
    public Iterator<E> iterator() {
        return this.stream().iterator();
    }
}

