/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.function.Predicate;
import org.perfectable.introspection.query.AnnotationFilters;

@FunctionalInterface
public interface AnnotationFilter {
    public static final AnnotationFilter ACCEPTING = AnnotationFilters.Accepting.INSTANCE;
    public static final AnnotationFilter REJECTING = AnnotationFilters.Rejecting.INSTANCE;
    public static final AnnotationFilter ABSENT = AnnotationFilters.Absent.INSTANCE;

    public static <A extends Annotation> Singular<A> single(Class<A> annotationClass) {
        return AnnotationFilters.Single.create(annotationClass);
    }

    public boolean matches(AnnotatedElement var1);

    default public AnnotationFilter and(AnnotationFilter other) {
        return AnnotationFilters.Conjunction.create(this, other);
    }

    default public AnnotationFilter or(AnnotationFilter other) {
        return AnnotationFilters.Disjunction.create(this, other);
    }

    default public AnnotationFilter negated() {
        return new AnnotationFilters.Negated(this);
    }

    public static interface Singular<A extends Annotation>
    extends AnnotationFilter {
        public Singular<A> andMatching(Predicate<? super A> var1);
    }
}

