/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.function.Predicate;
import org.perfectable.introspection.query.AnnotationFilter;

final class AnnotationFilters {
    private AnnotationFilters() {
    }

    static final class Conjunction
    implements AnnotationFilter {
        private final ImmutableSet<AnnotationFilter> components;

        static Conjunction create(AnnotationFilter ... components) {
            return new Conjunction((ImmutableSet<AnnotationFilter>)ImmutableSet.copyOf((Object[])components));
        }

        private Conjunction(ImmutableSet<AnnotationFilter> components) {
            this.components = components;
        }

        @Override
        public boolean matches(AnnotatedElement candidate) {
            return this.components.stream().allMatch(component -> component.matches(candidate));
        }

        @Override
        public AnnotationFilter and(AnnotationFilter other) {
            ImmutableSet newComponents = ImmutableSet.builder().addAll(this.components).add((Object)other).build();
            return new Conjunction((ImmutableSet<AnnotationFilter>)newComponents);
        }
    }

    static final class Disjunction
    implements AnnotationFilter {
        private final ImmutableSet<AnnotationFilter> components;

        static Disjunction create(AnnotationFilter ... components) {
            return new Disjunction((ImmutableSet<AnnotationFilter>)ImmutableSet.copyOf((Object[])components));
        }

        private Disjunction(ImmutableSet<AnnotationFilter> components) {
            this.components = components;
        }

        @Override
        public boolean matches(AnnotatedElement candidate) {
            return this.components.stream().anyMatch(component -> component.matches(candidate));
        }

        @Override
        public AnnotationFilter or(AnnotationFilter other) {
            ImmutableSet newComponents = ImmutableSet.builder().addAll(this.components).add((Object)other).build();
            return new Disjunction((ImmutableSet<AnnotationFilter>)newComponents);
        }
    }

    static final class Negated
    implements AnnotationFilter {
        private final AnnotationFilter positive;

        Negated(AnnotationFilter positive) {
            this.positive = positive;
        }

        @Override
        public boolean matches(AnnotatedElement candidate) {
            return !this.positive.matches(candidate);
        }

        @Override
        public AnnotationFilter negated() {
            return this.positive;
        }

        @Override
        public AnnotationFilter or(AnnotationFilter other) {
            if (other instanceof Negated) {
                return this.positive.and(((Negated)other).positive).negated();
            }
            return AnnotationFilter.super.or(other);
        }

        @Override
        public AnnotationFilter and(AnnotationFilter other) {
            if (other instanceof Negated) {
                return this.positive.or(((Negated)other).positive).negated();
            }
            return AnnotationFilter.super.and(other);
        }
    }

    static final class Absent
    implements AnnotationFilter {
        public static final AnnotationFilter INSTANCE = new Absent();

        private Absent() {
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            return element.getAnnotations().length == 0;
        }
    }

    static final class Rejecting
    implements AnnotationFilter {
        public static final AnnotationFilter INSTANCE = new Rejecting();

        private Rejecting() {
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            return false;
        }
    }

    static final class Accepting
    implements AnnotationFilter {
        public static final AnnotationFilter INSTANCE = new Accepting();

        private Accepting() {
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            return true;
        }
    }

    static final class Single<A extends Annotation>
    implements AnnotationFilter.Singular<A> {
        private final Class<A> annotationClass;
        private final Predicate<A> predicate;

        public static <A extends Annotation> Single<A> create(Class<A> annotationClass) {
            return new Single<Annotation>(annotationClass, Objects::nonNull);
        }

        private Single(Class<A> annotationClass, Predicate<A> predicate) {
            this.annotationClass = annotationClass;
            this.predicate = predicate;
        }

        @Override
        public AnnotationFilter.Singular<A> andMatching(Predicate<? super A> addedPredicate) {
            return new Single<A>(this.annotationClass, this.predicate.and(addedPredicate));
        }

        @Override
        public boolean matches(AnnotatedElement element) {
            A annotation = element.getAnnotation(this.annotationClass);
            return this.predicate.test(annotation);
        }
    }
}

