/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.perfectable.introspection.query.AbstractQuery;

public abstract class AnnotationQuery<A extends Annotation>
extends AbstractQuery<A, AnnotationQuery<A>> {
    public static AnnotationQuery<Annotation> empty() {
        return Empty.INSTANCE;
    }

    public static AnnotationQuery<Annotation> of(AnnotatedElement element) {
        return new OfElement(element);
    }

    public static AnnotationQuery<Annotation> fromElements(Set<Annotation> set) {
        return new OfSet((ImmutableSet<Annotation>)ImmutableSet.copyOf(set));
    }

    public static AnnotationQuery<Annotation> fromElements(Annotation ... elements) {
        return AnnotationQuery.fromElements((Set<Annotation>)ImmutableSet.copyOf((Object[])elements));
    }

    public AnnotationQuery<Annotation> join(AnnotationQuery<?> other) {
        return Composite.composite(new AnnotationQuery[]{this, other});
    }

    @Override
    public AnnotationQuery<A> filter(Predicate<? super A> filter) {
        Objects.requireNonNull(filter);
        return new Predicated<A>(this, filter);
    }

    public AnnotationQuery<A> annotatedWith(Class<? extends Annotation> metaAnnotation) {
        Objects.requireNonNull(metaAnnotation);
        return new Annotated(this, metaAnnotation);
    }

    public <X extends Annotation> AnnotationQuery<X> typed(Class<X> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return new Typed<X>(this, annotationClass);
    }

    public AnnotationQuery<Annotation> withRepeatableUnroll() {
        return new RepeatableUnroll(this);
    }

    AnnotationQuery() {
    }

    private static final class Composite<A extends Annotation>
    extends AnnotationQuery<A> {
        private final ImmutableList<AnnotationQuery<? extends A>> components;

        private Composite(ImmutableList<AnnotationQuery<? extends A>> components) {
            this.components = components;
        }

        private static <A extends Annotation> AnnotationQuery<A> composite(AnnotationQuery<? extends A> ... components) {
            return new Composite<A>(ImmutableList.copyOf((Object[])components));
        }

        @Override
        public Stream<A> stream() {
            return this.components.stream().flatMap(AbstractQuery::stream);
        }

        @Override
        public AnnotationQuery<Annotation> join(AnnotationQuery<?> other) {
            ImmutableList newComponents = ImmutableList.builder().addAll(this.components).add(other).build();
            return new Composite<Annotation>(newComponents);
        }

        @Override
        public boolean contains(Object candidate) {
            return this.components.stream().anyMatch(component -> component.contains(candidate));
        }
    }

    private static final class RepeatableUnroll
    extends AnnotationQuery<Annotation> {
        private static final Set<Class<? extends Annotation>> KNOWN_NON_CONTAINERS = Collections.newSetFromMap(new ConcurrentHashMap());
        private static final Map<Class<? extends Annotation>, Method> KNOWN_CONTAINERS = new ConcurrentHashMap<Class<? extends Annotation>, Method>();
        private final AnnotationQuery<?> parent;

        RepeatableUnroll(AnnotationQuery<?> parent) {
            this.parent = parent;
        }

        @Override
        public Stream<Annotation> stream() {
            return this.parent.stream().flatMap(this::unroll);
        }

        @Override
        public boolean contains(Object candidate) {
            if (this.parent.contains(candidate)) {
                return true;
            }
            if (!(candidate instanceof Annotation)) {
                return false;
            }
            Annotation candidateAnnotation = (Annotation)candidate;
            Repeatable repeatableAnnotation = candidateAnnotation.annotationType().getAnnotation(Repeatable.class);
            if (repeatableAnnotation == null) {
                return false;
            }
            Class<? extends Annotation> containerType = repeatableAnnotation.value();
            Method extractionMethod = KNOWN_CONTAINERS.computeIfAbsent(containerType, RepeatableUnroll::findContainerMethod);
            return this.parent.typed(containerType).stream().flatMap(container -> this.extractContents((Annotation)container, extractionMethod)).anyMatch(candidate::equals);
        }

        private Stream<Annotation> unroll(Annotation source) {
            Stream<Annotation> baseResult = Stream.of(source);
            Class<? extends Annotation> sourceClass = source.annotationType();
            if (KNOWN_NON_CONTAINERS.contains(sourceClass)) {
                return baseResult;
            }
            try {
                Method extractionMethod = KNOWN_CONTAINERS.computeIfAbsent(sourceClass, RepeatableUnroll::findContainerMethod);
                Stream<Annotation> additionalResults = this.extractContents(source, extractionMethod);
                return Stream.concat(baseResult, additionalResults);
            }
            catch (IllegalArgumentException e) {
                KNOWN_NON_CONTAINERS.add(sourceClass);
                return baseResult;
            }
        }

        private static Method findContainerMethod(Class<? extends Annotation> candidateContainer) throws IllegalArgumentException {
            Method[] methods = candidateContainer.getDeclaredMethods();
            Optional<Method> valueMethodOption = Stream.of(methods).filter((? super T method) -> method.getName().equals("value")).findAny();
            if (!valueMethodOption.isPresent()) {
                throw new IllegalArgumentException();
            }
            Method valueMethod = valueMethodOption.get();
            Class<?> returnType = valueMethod.getReturnType();
            if (!returnType.isArray() || !Annotation.class.isAssignableFrom(returnType.getComponentType())) {
                throw new IllegalArgumentException();
            }
            Class<?> containedClass = returnType.getComponentType();
            Repeatable repeatableAnnotation = containedClass.getAnnotation(Repeatable.class);
            if (!repeatableAnnotation.value().equals(candidateContainer)) {
                throw new IllegalArgumentException();
            }
            return valueMethod;
        }

        public Stream<Annotation> extractContents(Annotation source, Method extractionMethod) {
            Object resultArray;
            try {
                resultArray = extractionMethod.invoke((Object)source, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            return IntStream.range(0, Array.getLength(resultArray)).mapToObj(i -> (Annotation)Array.get(resultArray, i));
        }
    }

    private static final class Empty
    extends AnnotationQuery<Annotation> {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public Stream<Annotation> stream() {
            return Stream.empty();
        }

        @Override
        public Empty filter(Predicate<? super Annotation> filter) {
            return INSTANCE;
        }

        @Override
        public AnnotationQuery<Annotation> join(AnnotationQuery<? extends Annotation> other) {
            return other;
        }

        @Override
        public boolean contains(Object candidate) {
            return false;
        }
    }

    private static final class Typed<X extends Annotation>
    extends AnnotationQuery<X> {
        private final AnnotationQuery<?> parent;
        private final Class<X> type;

        Typed(AnnotationQuery<?> parent, Class<X> type) {
            this.parent = parent;
            this.type = type;
        }

        @Override
        public Stream<X> stream() {
            return this.parent.stream().filter(this.type::isInstance).map(this.type::cast);
        }

        @Override
        public boolean contains(Object candidate) {
            return this.type.isInstance(candidate) && this.parent.contains(candidate);
        }
    }

    private static final class Annotated<A extends Annotation>
    extends Filtered<A> {
        private final Class<? extends Annotation> metaAnnotation;

        Annotated(AnnotationQuery<A> parent, Class<? extends Annotation> metaAnnotation) {
            super(parent);
            this.metaAnnotation = metaAnnotation;
        }

        @Override
        protected boolean matches(A candidate) {
            return candidate.annotationType().isAnnotationPresent(this.metaAnnotation);
        }
    }

    private static final class Predicated<A extends Annotation>
    extends Filtered<A> {
        private final Predicate<? super A> filter;

        Predicated(AnnotationQuery<A> parent, Predicate<? super A> filter) {
            super(parent);
            this.filter = filter;
        }

        @Override
        protected boolean matches(A candidate) {
            return this.filter.test(candidate);
        }
    }

    private static abstract class Filtered<A extends Annotation>
    extends AnnotationQuery<A> {
        private final AnnotationQuery<A> parent;

        Filtered(AnnotationQuery<A> parent) {
            this.parent = parent;
        }

        protected abstract boolean matches(A var1);

        @Override
        public Stream<A> stream() {
            return this.parent.stream().filter(this::matches);
        }

        @Override
        public boolean contains(Object candidate) {
            if (!(candidate instanceof Annotation)) {
                return false;
            }
            return this.matches((Annotation)candidate) && this.parent.contains(candidate);
        }
    }

    private static final class OfSet
    extends AnnotationQuery<Annotation> {
        private final ImmutableSet<Annotation> elements;

        OfSet(ImmutableSet<Annotation> elements) {
            this.elements = elements;
        }

        @Override
        public Stream<Annotation> stream() {
            return this.elements.stream();
        }
    }

    private static final class OfElement
    extends AnnotationQuery<Annotation> {
        private final AnnotatedElement element;

        OfElement(AnnotatedElement element) {
            this.element = element;
        }

        @Override
        public Stream<Annotation> stream() {
            return Stream.of(this.element.getAnnotations());
        }
    }
}

