/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.annotation.Nullable;
import org.perfectable.introspection.query.AbstractQuery;
import org.perfectable.introspection.query.AnnotationFilter;
import org.perfectable.introspection.query.Streams;

public final class ClassQuery<C>
extends AbstractQuery<Class<? extends C>, ClassQuery<C>> {
    private static final Predicate<? super String> DEFAULT_CLASSNAME_FILTER = className -> true;
    private static final Predicate<? super CtClass> DEFAULT_PRE_LOAD_FILTER = ctClass -> true;
    private static final Predicate<? super Class<?>> DEFAULT_POST_LOAD_FILTER = type -> true;
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final ClassQuery<Object> SYSTEM = new ClassQuery<Object>(Object.class, ClassPathResourceSource.INSTANCE, ClassPool.getDefault(), name -> ClassLoader.getSystemClassLoader().loadClass(name), DEFAULT_CLASSNAME_FILTER, DEFAULT_PRE_LOAD_FILTER, DEFAULT_POST_LOAD_FILTER);
    private final ResourceSource resources;
    private final ClassPool classPool;
    private final TypeLoader loader;
    private final Class<? extends C> castedType;
    private final Predicate<? super String> classNameFilter;
    private final Predicate<? super CtClass> preLoadFilter;
    private final Predicate<? super Class<? extends C>> postLoadFilter;

    public static ClassQuery<Object> system() {
        return SYSTEM;
    }

    public static ClassQuery<Object> of(ClassLoader loader) {
        Objects.requireNonNull(loader);
        ClassPool classPool1 = new ClassPool();
        classPool1.appendClassPath((ClassPath)new LoaderClassPath(loader));
        return new ClassQuery<Object>(Object.class, ClassLoaderResourceSource.of(loader), classPool1, loader::loadClass, DEFAULT_CLASSNAME_FILTER, DEFAULT_PRE_LOAD_FILTER, DEFAULT_POST_LOAD_FILTER);
    }

    private ClassQuery(Class<? extends C> castedType, ResourceSource resources, ClassPool classPool, TypeLoader loader, Predicate<? super String> classNameFilter, Predicate<? super CtClass> preLoadFilter, Predicate<? super Class<? extends C>> postLoadFilter) {
        this.castedType = castedType;
        this.resources = resources;
        this.classPool = classPool;
        this.loader = loader;
        this.classNameFilter = classNameFilter;
        this.preLoadFilter = preLoadFilter;
        this.postLoadFilter = postLoadFilter;
    }

    public <X extends C> ClassQuery<X> subtypeOf(Class<? extends X> supertype) {
        Predicate<? super CtClass> newPreLoadFilter = this.preLoadFilter.and(SubtypePredicate.of(supertype));
        return new ClassQuery<X>(supertype, this.resources, this.classPool, this.loader, this.classNameFilter, newPreLoadFilter, DEFAULT_POST_LOAD_FILTER);
    }

    public ClassQuery<C> inPackage(String filteredPackageName) {
        return this.withClassNameFilter(PackageNamePredicate.of(filteredPackageName));
    }

    public ClassQuery<C> inPackage(Package filteredPackage) {
        return this.inPackage(filteredPackage.getName());
    }

    @Override
    public ClassQuery<C> filter(Predicate<? super Class<? extends C>> filter) {
        Predicate<? super Class<? extends C>> newPostLoadFilter = this.postLoadFilter.and(filter);
        return new ClassQuery<C>(this.castedType, this.resources, this.classPool, this.loader, this.classNameFilter, this.preLoadFilter, newPostLoadFilter);
    }

    public ClassQuery<C> annotatedWith(Class<? extends Annotation> annotation) {
        return this.annotatedWith(AnnotationFilter.single(annotation));
    }

    public ClassQuery<C> annotatedWith(AnnotationFilter annotationFilter) {
        return this.withPreLoadFilter(AnnotationPredicate.of(annotationFilter));
    }

    @Override
    public Stream<Class<? extends C>> stream() {
        return this.resources.entries().filter(ClassQuery::isClass).map(ClassQuery::getClassName).filter(this.classNameFilter).map(this::preload).filter(this.preLoadFilter).map(this::load).flatMap(com.google.common.collect.Streams::stream).filter(this.postLoadFilter);
    }

    @Override
    public boolean contains(Object candidate) {
        CtClass preloaded;
        if (!(candidate instanceof Class)) {
            return false;
        }
        Class candidateClass = (Class)candidate;
        if (!DEFAULT_CLASSNAME_FILTER.equals(this.classNameFilter) && !this.classNameFilter.test(candidateClass.getName())) {
            return false;
        }
        if (!DEFAULT_POST_LOAD_FILTER.equals(this.postLoadFilter) && !this.postLoadFilter.test(candidateClass)) {
            return false;
        }
        if (!DEFAULT_PRE_LOAD_FILTER.equals(this.preLoadFilter) && !this.preLoadFilter.test((CtClass)(preloaded = this.preload(candidateClass.getName())))) {
            return false;
        }
        return this.resources.contains(ClassQuery.getClassPath(candidateClass));
    }

    private ClassQuery<C> withClassNameFilter(Predicate<? super String> additionalClassNameFilter) {
        Predicate<? super String> newClassNameFilter = this.classNameFilter.and(additionalClassNameFilter);
        return new ClassQuery<C>(this.castedType, this.resources, this.classPool, this.loader, newClassNameFilter, this.preLoadFilter, DEFAULT_POST_LOAD_FILTER);
    }

    private ClassQuery<C> withPreLoadFilter(Predicate<? super CtClass> additionalPreLoadFilter) {
        Predicate<? super CtClass> newPreLoadFilter = this.preLoadFilter.and(additionalPreLoadFilter);
        return new ClassQuery<C>(this.castedType, this.resources, this.classPool, this.loader, this.classNameFilter, newPreLoadFilter, DEFAULT_POST_LOAD_FILTER);
    }

    private static boolean isClass(String path) {
        return path.endsWith(CLASS_FILE_SUFFIX) && !path.endsWith("package-info.class") && !path.endsWith("module-info.class");
    }

    private static String getClassName(String path) {
        int classNameEnd = path.length() - CLASS_FILE_SUFFIX.length();
        return path.substring(0, classNameEnd).replace('/', '.');
    }

    private static String getClassPath(Class<?> resolvedClass) {
        return resolvedClass.getName().replace('.', '/') + CLASS_FILE_SUFFIX;
    }

    private CtClass preload(String className) {
        try {
            return this.classPool.get(className);
        }
        catch (NotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Optional<Class<? extends C>> load(CtClass preloadedClass) {
        try {
            Class<? extends C> loaded = this.loader.load(preloadedClass.getName()).asSubclass(this.castedType);
            return Optional.of(loaded);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    private static final class CtClassAnnotatedElementAdapter
    implements AnnotatedElement {
        private final CtClass ctClass;

        static CtClassAnnotatedElementAdapter adapt(CtClass preloadedClass) {
            return new CtClassAnnotatedElementAdapter(preloadedClass);
        }

        private CtClassAnnotatedElementAdapter(CtClass ctClass) {
            this.ctClass = ctClass;
        }

        @Override
        @Nullable
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            try {
                return (T)((Annotation)this.ctClass.getAnnotation(annotationClass));
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Annotation[] getAnnotations() {
            throw new UnsupportedOperationException("Inherited annotation fetching is not currently supported");
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])this.ctClass.getAvailableAnnotations();
        }
    }

    private static final class ClassLoaderResourceSource
    extends UrlResourceSource {
        private final ClassLoader classLoader;

        public static ClassLoaderResourceSource of(ClassLoader classLoader) {
            return new ClassLoaderResourceSource(classLoader);
        }

        private ClassLoaderResourceSource(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        protected void generateUrls(Consumer<URL> urlAction) {
            for (ClassLoader currentClassLoader = this.classLoader; currentClassLoader != null; currentClassLoader = currentClassLoader.getParent()) {
                if (!(currentClassLoader instanceof URLClassLoader)) continue;
                URLClassLoader urlClassLoader = (URLClassLoader)currentClassLoader;
                for (URL url : urlClassLoader.getURLs()) {
                    urlAction.accept(url);
                }
            }
        }
    }

    private static final class ClassPathResourceSource
    extends UrlResourceSource {
        static final ClassPathResourceSource INSTANCE = new ClassPathResourceSource();
        private static final Splitter CLASSPATH_SPLITTER = Splitter.on((char)':');
        private static final String ENTRY_URL_PREFIX = "file://";

        private ClassPathResourceSource() {
        }

        @Override
        protected void generateUrls(Consumer<URL> urlAction) {
            String classPathString = System.getProperty("java.class.path");
            Iterable classPathEntries = CLASSPATH_SPLITTER.split((CharSequence)classPathString);
            for (String entry : classPathEntries) {
                if (entry.endsWith("*")) {
                    throw new AssertionError((Object)"Wild-carded classpath is unsupported");
                }
                URL url = ClassPathResourceSource.safeToUrl(ENTRY_URL_PREFIX + entry);
                urlAction.accept(url);
            }
        }
    }

    private static abstract class UrlResourceSource
    implements ResourceSource {
        public static final Splitter MANIFEST_CLASSPATH_ENTRY_SPLITTER = Splitter.on((String)" ");

        private UrlResourceSource() {
        }

        @Override
        public Stream<String> entries() {
            HashSet visited = new HashSet();
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            this.generateUrls(url -> UrlResourceSource.generateUrlEntry(url, (ImmutableSet.Builder<String>)resultBuilder, visited));
            return resultBuilder.build().stream();
        }

        @Override
        public boolean contains(String candidate) {
            return this.entries().anyMatch(candidate::equals);
        }

        protected abstract void generateUrls(Consumer<URL> var1);

        private static void generateUrlEntry(URL url, ImmutableSet.Builder<String> resultBuilder, Set<File> visited) {
            File file = new File(url.getFile());
            if (visited.contains(file)) {
                return;
            }
            visited.add(file);
            if (file.isDirectory()) {
                UrlResourceSource.generateDirectoryEntries(file, resultBuilder);
            } else {
                UrlResourceSource.generateJarEntries(file, resultBuilder, visited);
            }
        }

        private static void generateJarEntries(File jarPath, ImmutableSet.Builder<String> resultBuilder, Set<File> visited) {
            String manifestClassPath;
            try (JarFile jarFile = new JarFile(jarPath);){
                manifestClassPath = UrlResourceSource.getManifestClassPathString(jarFile);
                Streams.from(jarFile.entries()).filter(entry -> !entry.isDirectory()).map(ZipEntry::getName).forEach(arg_0 -> resultBuilder.add(arg_0));
            }
            catch (IOException ignored) {
                return;
            }
            if (manifestClassPath == null) {
                return;
            }
            for (String manifestEntry : MANIFEST_CLASSPATH_ENTRY_SPLITTER.split((CharSequence)manifestClassPath)) {
                URL manifestUrl = UrlResourceSource.safeToUrl(manifestEntry);
                UrlResourceSource.generateUrlEntry(manifestUrl, resultBuilder, visited);
            }
        }

        private static void generateDirectoryEntries(File directoryBase, ImmutableSet.Builder<String> resultBuilder) {
            Path basePath = Paths.get(directoryBase.getPath(), new String[0]);
            try {
                Files.walkFileTree(basePath, new ResultAddingFileVisitor(resultBuilder, basePath));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Nullable
        private static String getManifestClassPathString(JarFile jarFile) throws IOException {
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return null;
            }
            return manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        }

        protected static URL safeToUrl(String entry) {
            try {
                return new URL(entry);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }

        private static class ResultAddingFileVisitor
        extends SimpleFileVisitor<Path> {
            private final ImmutableSet.Builder<String> resultBuilder;
            private final Path basePath;

            ResultAddingFileVisitor(ImmutableSet.Builder<String> resultBuilder, Path basePath) {
                this.resultBuilder = resultBuilder;
                this.basePath = basePath;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                Path relativePath = this.basePath.relativize(path);
                this.resultBuilder.add((Object)relativePath.toString());
                return FileVisitResult.CONTINUE;
            }
        }
    }

    private static interface ResourceSource {
        public Stream<String> entries();

        public boolean contains(String var1);
    }

    private static interface TypeLoader {
        public Class<?> load(String var1) throws ClassNotFoundException;
    }

    private static final class SubtypePredicate
    implements Predicate<CtClass> {
        private final Class<?> supertype;

        public static SubtypePredicate of(Class<?> supertype) {
            return new SubtypePredicate(supertype);
        }

        private SubtypePredicate(Class<?> supertype) {
            this.supertype = supertype;
        }

        @Override
        public boolean test(CtClass ctClass) {
            return ctClass.getName().equals(this.supertype.getName()) || this.testSuperclass(ctClass) || this.testInterfaces(ctClass);
        }

        private boolean testSuperclass(CtClass ctClass) {
            CtClass superclass;
            try {
                superclass = ctClass.getSuperclass();
            }
            catch (Exception ignored) {
                return false;
            }
            return superclass != null && this.test(superclass);
        }

        private boolean testInterfaces(CtClass ctClass) {
            CtClass[] ctInterfaces;
            try {
                ctInterfaces = ctClass.getInterfaces();
            }
            catch (Exception ignored) {
                return false;
            }
            for (CtClass ctInterface : ctInterfaces) {
                if (!this.test(ctInterface)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class AnnotationPredicate
    implements Predicate<CtClass> {
        private final AnnotationFilter annotationFilter;

        public static AnnotationPredicate of(AnnotationFilter annotationFilter) {
            return new AnnotationPredicate(annotationFilter);
        }

        private AnnotationPredicate(AnnotationFilter annotationFilter) {
            this.annotationFilter = annotationFilter;
        }

        @Override
        public boolean test(CtClass preloadedClass) {
            return this.annotationFilter.matches(CtClassAnnotatedElementAdapter.adapt(preloadedClass));
        }
    }

    private static final class PackageNamePredicate
    implements Predicate<String> {
        private final String filteredPackageName;

        public static PackageNamePredicate of(String filteredPackageName) {
            return new PackageNamePredicate(filteredPackageName);
        }

        private PackageNamePredicate(String filteredPackageName) {
            this.filteredPackageName = filteredPackageName;
        }

        @Override
        public boolean test(String className) {
            return className.startsWith(this.filteredPackageName);
        }
    }
}

