/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.perfectable.introspection.query.AbstractQuery;
import org.perfectable.introspection.query.AnnotationFilter;
import org.perfectable.introspection.query.Streams;

public abstract class InheritanceQuery<X>
extends AbstractQuery<Class<? super X>, InheritanceQuery<X>> {
    public static <X> InheritanceQuery<X> of(Class<X> type) {
        return new Complete<X>(type);
    }

    public InheritanceQuery<X> annotatedWith(Class<? extends Annotation> annotationClass) {
        return this.annotatedWith(AnnotationFilter.single(annotationClass));
    }

    public InheritanceQuery<X> annotatedWith(AnnotationFilter annotationFilter) {
        Objects.requireNonNull(annotationFilter);
        return new Annotated(this, annotationFilter);
    }

    @Override
    public InheritanceQuery<X> filter(Predicate<? super Class<? super X>> filter) {
        return new Predicated(this, filter);
    }

    public InheritanceQuery<X> upToExcluding(Class<? super X> supertype) {
        return new BoundingExcluded<X>(this, supertype);
    }

    public InheritanceQuery<X> upToIncluding(Class<? super X> supertype) {
        return new BoundingIncluded<X>(this, supertype);
    }

    public InheritanceQuery<X> onlyInterfaces() {
        return new InterfacesOnly(this);
    }

    public InheritanceQuery<X> onlyClasses() {
        return new ClassesOnly(this);
    }

    InheritanceQuery() {
    }

    private static <X> Stream<Class<? super X>> safeGetSupertypes(Class<? super X> type) {
        Stream.Builder<Class<? super X>> builder = Stream.builder();
        Class<?>[] interfaceArray = type.getInterfaces();
        Stream.of(interfaceArray).forEach(builder);
        Class<? super X> superclass = type.getSuperclass();
        if (superclass != null) {
            builder.accept(superclass);
        }
        return builder.build();
    }

    private static final class ClassesOnly<X>
    extends Filtered<X> {
        ClassesOnly(InheritanceQuery<X> parent) {
            super(parent);
        }

        @Override
        protected boolean matches(Class<? super X> candidate) {
            return !candidate.isInterface();
        }
    }

    private static final class InterfacesOnly<X>
    extends Filtered<X> {
        InterfacesOnly(InheritanceQuery<X> parent) {
            super(parent);
        }

        @Override
        protected boolean matches(Class<? super X> candidate) {
            return candidate.isInterface();
        }
    }

    private static final class BoundingIncluded<X>
    extends Filtered<X> {
        private final Class<? super X> supertype;

        BoundingIncluded(InheritanceQuery<X> parent, Class<? super X> supertype) {
            super(parent);
            this.supertype = supertype;
        }

        @Override
        protected boolean matches(Class<? super X> candidate) {
            return this.supertype.isAssignableFrom(candidate);
        }
    }

    private static final class BoundingExcluded<X>
    extends Filtered<X> {
        private final Class<? super X> supertype;

        BoundingExcluded(InheritanceQuery<X> parent, Class<? super X> supertype) {
            super(parent);
            this.supertype = supertype;
        }

        @Override
        protected boolean matches(Class<? super X> candidate) {
            return this.supertype.isAssignableFrom(candidate) && !this.supertype.equals(candidate);
        }
    }

    private static final class Predicated<X>
    extends Filtered<X> {
        private final Predicate<? super Class<? super X>> filter;

        Predicated(InheritanceQuery<X> parent, Predicate<? super Class<? super X>> filter) {
            super(parent);
            this.filter = filter;
        }

        @Override
        protected boolean matches(Class<? super X> candidate) {
            return this.filter.test(candidate);
        }
    }

    private static final class Annotated<X>
    extends Filtered<X> {
        private final AnnotationFilter annotationFilter;

        Annotated(InheritanceQuery<X> parent, AnnotationFilter annotationFilter) {
            super(parent);
            this.annotationFilter = annotationFilter;
        }

        @Override
        protected boolean matches(Class<? super X> candidate) {
            return this.annotationFilter.matches(candidate);
        }
    }

    private static abstract class Filtered<X>
    extends InheritanceQuery<X> {
        private final InheritanceQuery<X> parent;

        Filtered(InheritanceQuery<X> parent) {
            this.parent = parent;
        }

        protected abstract boolean matches(Class<? super X> var1);

        @Override
        public Stream<Class<? super X>> stream() {
            return this.parent.stream().filter(this::matches);
        }

        @Override
        public boolean contains(Object candidate) {
            if (!(candidate instanceof Class)) {
                return false;
            }
            Class candidateClass = (Class)candidate;
            return this.matches(candidateClass) && this.parent.contains(candidate);
        }
    }

    private static final class Complete<X>
    extends InheritanceQuery<X> {
        private final Class<X> initial;

        Complete(Class<X> initial) {
            this.initial = initial;
        }

        @Override
        public Stream<Class<? super X>> stream() {
            return Streams.generateSingle(this.initial, x$0 -> InheritanceQuery.safeGetSupertypes(x$0));
        }

        @Override
        public boolean contains(Object candidate) {
            if (!(candidate instanceof Class)) {
                return false;
            }
            Class candidateClass = (Class)candidate;
            return candidateClass.isAssignableFrom(this.initial);
        }
    }
}

