/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.perfectable.introspection.PrivilegedActions;
import org.perfectable.introspection.query.AbstractQuery;
import org.perfectable.introspection.query.AnnotationFilter;
import org.perfectable.introspection.query.ExecutableQuery;
import org.perfectable.introspection.query.InheritanceQuery;
import org.perfectable.introspection.query.ParametersFilter;
import org.perfectable.introspection.query.TypeFilter;

public abstract class MethodQuery
extends ExecutableQuery<Method, MethodQuery> {
    public static MethodQuery of(Class<?> type) {
        Objects.requireNonNull(type);
        return new Complete(type);
    }

    @Override
    public MethodQuery named(String name) {
        Objects.requireNonNull(name);
        return new Named(this, name);
    }

    @Override
    public MethodQuery nameMatching(Pattern namePattern) {
        Objects.requireNonNull(namePattern);
        return new NameMatching(this, namePattern);
    }

    @Override
    public MethodQuery filter(Predicate<? super Method> filter) {
        Objects.requireNonNull(filter);
        return new Predicated(this, filter);
    }

    @Override
    public MethodQuery parameters(ParametersFilter parametersFilter) {
        Objects.requireNonNull(parametersFilter);
        return new Parameters(this, parametersFilter);
    }

    public MethodQuery returning(Type type) {
        return this.returning(TypeFilter.subtypeOf(type));
    }

    public MethodQuery returning(TypeFilter typeFilter) {
        Objects.requireNonNull(typeFilter);
        return new Returning(this, typeFilter);
    }

    public MethodQuery returningVoid() {
        return this.returning(Void.TYPE);
    }

    public MethodQuery notOverridden() {
        return new NotOverriden(this);
    }

    @Override
    public MethodQuery annotatedWith(AnnotationFilter annotationFilter) {
        Objects.requireNonNull(annotationFilter);
        return new Annotated(this, annotationFilter);
    }

    @Override
    public MethodQuery requiringModifier(int requiredModifier) {
        return new RequiringModifier(this, requiredModifier);
    }

    @Override
    public MethodQuery excludingModifier(int excludedModifier) {
        return new ExcludingModifier(this, excludedModifier);
    }

    @Override
    public MethodQuery asAccessible() {
        return new AccessibleMarking(this);
    }

    MethodQuery() {
    }

    private static final class NotOverriden
    extends MethodQuery {
        private final MethodQuery parent;

        NotOverriden(MethodQuery parent) {
            this.parent = parent;
        }

        @Override
        public Stream<Method> stream() {
            HashSet processedMethods = new HashSet();
            return this.parent.stream().filter((? super T candidate) -> processedMethods.stream().filter((? super T processed) -> NotOverriden.hasEquivalentSignature(candidate, processed)).noneMatch(processed -> NotOverriden.isOverriddenByAssumingSignature(candidate, processed))).peek(processedMethods::add);
        }

        @Override
        public boolean contains(Object candidate) {
            if (!(candidate instanceof Method)) {
                return false;
            }
            if (!this.parent.contains(candidate)) {
                return false;
            }
            Method candidateMethod = (Method)candidate;
            AbstractQuery overriding = ((MethodQuery)this.parent.parameters(ParametersFilter.typesExact(candidateMethod.getParameterTypes())).named(candidateMethod.getName()).filter((T method) -> !candidate.equals(method))).filter((T method) -> NotOverriden.isOverriddenByAssumingSignature(candidateMethod, method));
            return !((MethodQuery)overriding).isPresent();
        }

        private static boolean hasEquivalentSignature(Method left, Method right) {
            return left.getName().equals(right.getName()) && Arrays.equals(left.getParameterTypes(), right.getParameterTypes());
        }

        private static boolean isOverriddenByAssumingSignature(Method method, Method potentialOverride) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                return false;
            }
            Class<?> declaringClass = method.getDeclaringClass();
            Class<?> potentialOverrideDeclaringClass = potentialOverride.getDeclaringClass();
            Package methodPackage = declaringClass.getPackage();
            Package potentialOverridePackage = potentialOverrideDeclaringClass.getPackage();
            boolean samePackage = methodPackage.equals(potentialOverridePackage);
            if (!(Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers) || samePackage)) {
                return false;
            }
            return declaringClass.isAssignableFrom(potentialOverrideDeclaringClass);
        }
    }

    private static final class AccessibleMarking
    extends MethodQuery {
        private final MethodQuery parent;

        AccessibleMarking(MethodQuery parent) {
            this.parent = parent;
        }

        @Override
        public Stream<Method> stream() {
            return this.parent.stream().peek(PrivilegedActions::markAccessible);
        }

        @Override
        public boolean contains(Object candidate) {
            return this.parent.contains(candidate);
        }
    }

    private static final class ExcludingModifier
    extends Filtered {
        private final int excludedModifier;

        ExcludingModifier(MethodQuery parent, int excludedModifier) {
            super(parent);
            this.excludedModifier = excludedModifier;
        }

        @Override
        protected boolean matches(Method candidate) {
            return (candidate.getModifiers() & this.excludedModifier) == 0;
        }
    }

    private static final class RequiringModifier
    extends Filtered {
        private final int requiredModifier;

        RequiringModifier(MethodQuery parent, int requiredModifier) {
            super(parent);
            this.requiredModifier = requiredModifier;
        }

        @Override
        protected boolean matches(Method candidate) {
            return (candidate.getModifiers() & this.requiredModifier) != 0;
        }
    }

    private static final class Annotated
    extends Filtered {
        private final AnnotationFilter annotationFilter;

        Annotated(MethodQuery parent, AnnotationFilter annotationFilter) {
            super(parent);
            this.annotationFilter = annotationFilter;
        }

        @Override
        protected boolean matches(Method candidate) {
            return this.annotationFilter.matches(candidate);
        }
    }

    private static final class Returning
    extends Filtered {
        private final TypeFilter typeFilter;

        Returning(MethodQuery parent, TypeFilter typeFilter) {
            super(parent);
            this.typeFilter = typeFilter;
        }

        @Override
        protected boolean matches(Method candidate) {
            return this.typeFilter.matches(candidate.getReturnType());
        }
    }

    private static final class Parameters
    extends Filtered {
        private final ParametersFilter parametersFilter;

        Parameters(MethodQuery parent, ParametersFilter parametersFilter) {
            super(parent);
            this.parametersFilter = parametersFilter;
        }

        @Override
        protected boolean matches(Method candidate) {
            return this.parametersFilter.matches(candidate);
        }
    }

    private static final class NameMatching
    extends Filtered {
        private final Pattern namePattern;

        NameMatching(MethodQuery parent, Pattern namePattern) {
            super(parent);
            this.namePattern = namePattern;
        }

        @Override
        protected boolean matches(Method candidate) {
            return this.namePattern.matcher(candidate.getName()).matches();
        }
    }

    private static final class Named
    extends Filtered {
        private final String name;

        Named(MethodQuery parent, String name) {
            super(parent);
            this.name = name;
        }

        @Override
        protected boolean matches(Method candidate) {
            return this.name.equals(candidate.getName());
        }
    }

    private static final class Predicated
    extends Filtered {
        private final Predicate<? super Method> filter;

        Predicated(MethodQuery parent, Predicate<? super Method> filter) {
            super(parent);
            this.filter = filter;
        }

        @Override
        protected boolean matches(Method candidate) {
            return this.filter.test(candidate);
        }
    }

    private static abstract class Filtered
    extends MethodQuery {
        private final MethodQuery parent;

        Filtered(MethodQuery parent) {
            this.parent = parent;
        }

        protected abstract boolean matches(Method var1);

        @Override
        public Stream<Method> stream() {
            return this.parent.stream().filter(this::matches);
        }

        @Override
        public boolean contains(Object candidate) {
            if (!(candidate instanceof Method)) {
                return false;
            }
            Method candidateMethod = (Method)candidate;
            return this.matches(candidateMethod) && this.parent.contains(candidate);
        }
    }

    private static final class Complete<X>
    extends MethodQuery {
        private final InheritanceQuery<X> chain;

        Complete(Class<X> type) {
            this.chain = InheritanceQuery.of(type);
        }

        @Override
        public Stream<Method> stream() {
            return this.chain.stream().flatMap(testedClass -> Stream.of(testedClass.getDeclaredMethods()));
        }

        @Override
        public boolean contains(Object candidate) {
            if (!(candidate instanceof Method)) {
                return false;
            }
            Method candidateMethod = (Method)candidate;
            Class<?> declaringClass = candidateMethod.getDeclaringClass();
            return this.chain.contains(declaringClass);
        }
    }
}

