/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.perfectable.introspection.query.ParametersFilter;
import org.perfectable.introspection.query.TypeFilter;

final class ParameterFilters {
    static ParametersFilter matchingArguments(Object ... arguments) {
        ImmutableList.Builder filters = ImmutableList.builder();
        for (Object argument : arguments) {
            TypeFilter filter;
            if (argument == null) {
                filter = TypeFilter.PRIMITIVE.negated();
            } else {
                Class<?> argumentClass = argument.getClass();
                filter = TypeFilter.superTypeOf(argumentClass);
                if (Primitives.isWrapperType(argumentClass)) {
                    filter = filter.or(TypeFilter.exact(Primitives.unwrap(argumentClass)));
                }
            }
            filters.add((Object)filter);
        }
        return Types.of((ImmutableList<TypeFilter>)filters.build());
    }

    private ParameterFilters() {
    }

    static final class Count
    implements ParametersFilter {
        private final int number;

        static Count of(int number) {
            return new Count(number);
        }

        private Count(int number) {
            this.number = number;
        }

        @Override
        public boolean matches(Parameter[] parameters, boolean varArgs) {
            return varArgs ? parameters.length <= this.number + 1 : parameters.length == this.number;
        }
    }

    static final class Types
    implements ParametersFilter {
        private final ImmutableList<TypeFilter> parameterTypes;

        static Types accepting(Type ... parameterTypes) {
            ImmutableList typeFilters = (ImmutableList)Stream.of(parameterTypes).map(TypeFilter::superTypeOf).collect(ImmutableList.toImmutableList());
            return new Types((ImmutableList<TypeFilter>)typeFilters);
        }

        static Types exact(Type ... parameterTypes) {
            ImmutableList typeFilters = (ImmutableList)Stream.of(parameterTypes).map(TypeFilter::exact).collect(ImmutableList.toImmutableList());
            return Types.of((ImmutableList<TypeFilter>)typeFilters);
        }

        static Types of(TypeFilter ... parameterTypes) {
            ImmutableList typeFilters = ImmutableList.copyOf((Object[])parameterTypes);
            return Types.of((ImmutableList<TypeFilter>)typeFilters);
        }

        static Types of(ImmutableList<TypeFilter> parameterTypes) {
            return new Types(parameterTypes);
        }

        private Types(ImmutableList<TypeFilter> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public boolean matches(Parameter[] parameters, boolean varArgs) {
            return varArgs ? this.matchesVarargs(parameters) : this.matchesNormal(parameters);
        }

        private boolean matchesVarargs(Parameter[] parameters) {
            Preconditions.checkArgument((parameters.length > 0 ? 1 : 0) != 0);
            Parameter lastParameter = parameters[parameters.length - 1];
            UnmodifiableIterator expectedFilterIterator = this.parameterTypes.iterator();
            UnmodifiableIterator parameterIterator = Iterators.forArray((Object[])parameters);
            while (expectedFilterIterator.hasNext()) {
                Parameter parameter;
                Class<?> actualParameterType;
                TypeFilter typeFilter = (TypeFilter)expectedFilterIterator.next();
                if (typeFilter.matches(actualParameterType = (parameter = parameterIterator.hasNext() ? (Parameter)parameterIterator.next() : lastParameter).equals(lastParameter) ? parameter.getType().getComponentType() : parameter.getType())) continue;
                return false;
            }
            return !parameterIterator.hasNext() || ((Parameter)parameterIterator.next()).equals(lastParameter);
        }

        private boolean matchesNormal(Parameter[] parameters) {
            UnmodifiableIterator expectedFilterIterator = this.parameterTypes.iterator();
            UnmodifiableIterator parameterIterator = Iterators.forArray((Object[])parameters);
            while (expectedFilterIterator.hasNext()) {
                Parameter parameter;
                Class<?> actualParameterType;
                if (!parameterIterator.hasNext()) {
                    return false;
                }
                TypeFilter typeFilter = (TypeFilter)expectedFilterIterator.next();
                if (typeFilter.matches(actualParameterType = (parameter = (Parameter)parameterIterator.next()).getType())) continue;
                return false;
            }
            return !parameterIterator.hasNext();
        }
    }
}

