/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.query;

import java.lang.reflect.Type;
import org.perfectable.introspection.query.TypeFilters;

@FunctionalInterface
public interface TypeFilter {
    public static final TypeFilter ALL = TypeFilters.Complete.INSTANCE;
    public static final TypeFilter NONE = TypeFilters.Empty.INSTANCE;
    public static final TypeFilter PRIMITIVE = TypeFilters.Primitive.INSTANCE;

    public static TypeFilter superTypeOf(Type subType) {
        return ALL.withLowerBound(subType);
    }

    public static TypeFilter subtypeOf(Type superType) {
        return ALL.withUpperBound(superType);
    }

    public static TypeFilter exact(Type matchedType) {
        return new TypeFilters.Exact(matchedType);
    }

    public boolean matches(Type var1);

    default public TypeFilter withUpperBound(Type superType) {
        return new TypeFilters.UpperBounded(this, superType);
    }

    default public TypeFilter withLowerBound(Type subType) {
        return new TypeFilters.LowerBounded(this, subType);
    }

    default public TypeFilter withExcluded(Type excludedType) {
        return this.and(TypeFilter.exact(excludedType).negated());
    }

    default public TypeFilter negated() {
        return new TypeFilters.Negated(this);
    }

    default public TypeFilter and(TypeFilter other) {
        return TypeFilters.Conjunction.create(this, other);
    }

    default public TypeFilter or(TypeFilter other) {
        return TypeFilters.Disjunction.create(this, other);
    }
}

