/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.perfectable.introspection.type.AbstractTypeView;
import org.perfectable.introspection.type.ClassView;
import org.perfectable.introspection.type.ParameterizedTypeView;
import org.perfectable.introspection.type.SyntheticGenericArrayType;
import org.perfectable.introspection.type.TypeVariableView;
import org.perfectable.introspection.type.TypeView;
import org.perfectable.introspection.type.VariableReplacer;
import org.perfectable.introspection.type.WildcardTypeView;

public final class ArrayTypeView
extends AbstractTypeView<GenericArrayType> {
    ArrayTypeView(GenericArrayType type) {
        super(type);
    }

    public static ArrayTypeView of(GenericArrayType genericArray) {
        return new ArrayTypeView(genericArray);
    }

    @Override
    public Class<?> erasure() {
        Class<?> componentErasure = this.component().erasure();
        return ArrayTypeView.makeArrayClass(componentErasure);
    }

    public TypeView component() {
        return ArrayTypeView.of(((GenericArrayType)this.type).getGenericComponentType());
    }

    @Override
    public ParameterizedTypeView asParameterized() {
        return this.asClass().asParameterized();
    }

    @Override
    public ClassView<?> asClass() {
        Type componentType = ((GenericArrayType)this.type).getGenericComponentType();
        Preconditions.checkState((boolean)(componentType instanceof Class), (String)"Component is not a class, it's %s", (Object)componentType);
        Class<?> arrayClass = ArrayTypeView.makeArrayClass((Class)componentType);
        return new ClassView(arrayClass);
    }

    @Override
    @Deprecated
    public TypeVariableView<?> asVariable() throws IllegalStateException {
        throw new IllegalStateException("Array type cannot be converted to variable");
    }

    @Override
    @Deprecated
    public WildcardTypeView asWildcard() throws IllegalStateException {
        throw new IllegalStateException("Array type cannot be converted to wildcard");
    }

    @Override
    @Deprecated
    public ArrayTypeView asArray() {
        return this;
    }

    @Override
    public boolean isSubTypeOf(TypeView other) {
        return other.visit(new TypeView.PartialVisitor<Boolean>(){

            @Override
            public Boolean visitParameterized(ParameterizedTypeView view) {
                if (!view.arguments().isEmpty()) {
                    return false;
                }
                Class<?> raw = view.erasure();
                return this.isRawSubtype(raw);
            }

            @Override
            public Boolean visitClass(ClassView<?> view) {
                Class raw = (Class)view.unwrap();
                if (Object.class.equals((Object)raw)) {
                    return true;
                }
                return this.isRawSubtype(raw);
            }

            @Override
            public Boolean visitWildcard(WildcardTypeView view) {
                return view.lowerBoundsStream().anyMatch(bound -> bound.isSuperTypeOf(ArrayTypeView.this.type));
            }

            @Override
            public Boolean visitArray(ArrayTypeView view) {
                return ArrayTypeView.this.component().isSubTypeOf(view.component());
            }

            @Override
            protected Boolean fallback() {
                return false;
            }

            private boolean isRawSubtype(Class<?> raw) {
                if (!raw.isArray()) {
                    return false;
                }
                return ArrayTypeView.this.component().isSubTypeOf(raw.getComponentType());
            }
        });
    }

    @Override
    public <T> T visit(TypeView.Visitor<T> visitor) {
        return visitor.visitArray(this);
    }

    @Override
    public ArrayTypeView resolve(TypeView other) {
        return this.component().resolve(other).makeArray();
    }

    @Override
    public ArrayTypeView resolve(Type other) {
        return (ArrayTypeView)super.resolve(other);
    }

    @Override
    TypeView replaceVariables(VariableReplacer substitutions) {
        TypeView component = this.component();
        TypeView replaced = component.replaceVariables(substitutions);
        return replaced.equals(component) ? this : ArrayTypeView.of(new SyntheticGenericArrayType(replaced.unwrap()));
    }

    @Override
    Type resolveVariable(TypeVariable<?> variable) {
        return this.component().resolveVariable(variable);
    }

    private static Class<?> makeArrayClass(Class<?> componentErasure) {
        return Array.newInstance(componentErasure, 0).getClass();
    }
}

