/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.perfectable.introspection.type.AbstractTypeView;
import org.perfectable.introspection.type.ArrayTypeView;
import org.perfectable.introspection.type.ParameterizedTypeView;
import org.perfectable.introspection.type.SyntheticGenericArrayType;
import org.perfectable.introspection.type.SyntheticParameterizedType;
import org.perfectable.introspection.type.TypeVariableView;
import org.perfectable.introspection.type.TypeView;
import org.perfectable.introspection.type.VariableReplacer;
import org.perfectable.introspection.type.WildcardTypeView;

public final class ClassView<X>
extends AbstractTypeView<Class<X>> {
    ClassView(Class<X> type) {
        super(type);
    }

    public static <X> ClassView<X> of(Class<X> clazz) {
        return new ClassView<X>(clazz);
    }

    public <S extends X> ClassView<S> adjustWildcards() {
        return this;
    }

    public Class<X> erasure() {
        return (Class)this.type;
    }

    public List<TypeVariableView<Class<X>>> parameters() {
        return Stream.of(((Class)this.type).getTypeParameters()).map(TypeView::of).collect(Collectors.toList());
    }

    @Override
    public ParameterizedTypeView asParameterized() {
        Type[] typeArguments = ((Class)this.type).getTypeParameters();
        Class<?> ownerType = ((Class)this.type).getEnclosingClass();
        SyntheticParameterizedType replaced = new SyntheticParameterizedType((Class)this.type, ownerType, typeArguments);
        return new ParameterizedTypeView(replaced);
    }

    @Override
    @Deprecated
    public ClassView<?> asClass() {
        return this;
    }

    @Override
    @Deprecated
    public TypeVariableView<?> asVariable() throws IllegalStateException {
        throw new IllegalStateException("Class cannot be converted to variable");
    }

    @Override
    @Deprecated
    public WildcardTypeView asWildcard() throws IllegalStateException {
        throw new IllegalStateException("Class cannot be converted to wildcard");
    }

    @Override
    public ArrayTypeView asArray() throws IllegalStateException {
        Preconditions.checkState((boolean)((Class)this.type).isArray());
        Class<?> componentType = ((Class)this.type).getComponentType();
        SyntheticGenericArrayType arrayType = new SyntheticGenericArrayType(componentType);
        return new ArrayTypeView(arrayType);
    }

    @Override
    public boolean isSubTypeOf(TypeView other) {
        return other.visit(new TypeView.Visitor<Boolean>(){

            @Override
            public Boolean visitParameterized(ParameterizedTypeView view) {
                return ClassView.this.asParameterized().isSubTypeOf(view);
            }

            @Override
            public Boolean visitClass(ClassView<?> view) {
                return ((Class)view.type).isAssignableFrom((Class)ClassView.this.type);
            }

            @Override
            public Boolean visitVariable(TypeVariableView<?> view) {
                return false;
            }

            @Override
            public Boolean visitWildcard(WildcardTypeView view) {
                return view.lowerBoundsStream().anyMatch(bound -> bound.isSuperTypeOf(ClassView.this.type));
            }

            @Override
            public Boolean visitArray(ArrayTypeView view) {
                if (!((Class)ClassView.this.type).isArray()) {
                    return false;
                }
                return ClassView.of(((Class)ClassView.this.type).getComponentType()).isSubTypeOf(view.component());
            }
        });
    }

    @Override
    public <T> T visit(TypeView.Visitor<T> visitor) {
        return visitor.visitClass(this);
    }

    @Override
    public ParameterizedTypeView resolve(Type other) {
        return this.asParameterized().resolve(other);
    }

    @Override
    public ParameterizedTypeView resolve(TypeView other) {
        return this.asParameterized().resolve(other);
    }

    @Override
    TypeView replaceVariables(VariableReplacer replacer) {
        ParameterizedTypeView parameterized = this.asParameterized();
        ParameterizedTypeView replaced = parameterized.replaceVariables(replacer);
        return replaced.equals(parameterized) ? this : replaced;
    }

    @Override
    Type resolveVariable(TypeVariable<?> variable) {
        return this.asParameterized().resolveVariable(variable);
    }

    @Override
    boolean containsVariant(TypeView other) {
        return other.visit(new TypeView.PartialVisitor<Boolean>(){

            @Override
            public Boolean visitClass(ClassView<?> view) {
                return ((Class)view.type).equals(ClassView.this.type);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public Boolean visitWildcard(WildcardTypeView view) {
                boolean bl;
                if (!view.lowerBoundsStream().map(TypeView::unwrap).allMatch(((Class)ClassView.this.type)::equals)) {
                    if (!view.upperBoundsStream().map(TypeView::unwrap).allMatch(((Class)ClassView.this.type)::equals)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }

            @Override
            protected Boolean fallback() {
                return false;
            }
        });
    }
}

