/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.perfectable.introspection.type.AbstractTypeView;
import org.perfectable.introspection.type.ArrayTypeView;
import org.perfectable.introspection.type.ClassView;
import org.perfectable.introspection.type.SyntheticParameterizedType;
import org.perfectable.introspection.type.TypeVariableView;
import org.perfectable.introspection.type.TypeView;
import org.perfectable.introspection.type.VariableReplacer;
import org.perfectable.introspection.type.WildcardTypeView;

public final class ParameterizedTypeView
extends AbstractTypeView<ParameterizedType> {
    @LazyInit
    private ImmutableMap<TypeVariable<? extends Class<?>>, Type> calculatedSubstitutions;
    @LazyInit
    private ImmutableList<TypeView> correctedArguments;

    ParameterizedTypeView(ParameterizedType parameterizedType) {
        super(parameterizedType);
    }

    public static ParameterizedTypeView of(ParameterizedType parameterized) {
        return new ParameterizedTypeView(parameterized);
    }

    @Override
    public Class<?> erasure() {
        return (Class)((ParameterizedType)this.type).getRawType();
    }

    public List<TypeView> arguments() {
        if (this.correctedArguments == null) {
            this.correctedArguments = ParameterizedTypeView.calculateArguments((ParameterizedType)this.type);
        }
        return this.correctedArguments;
    }

    public Optional<ParameterizedTypeView> superclass() {
        Type genericSuperclass = this.erasure().getGenericSuperclass();
        if (genericSuperclass == null) {
            return Optional.empty();
        }
        VariableReplacer replacer = VariableReplacer.map(this.substitutions());
        ParameterizedTypeView result = ParameterizedTypeView.of(genericSuperclass).replaceVariables(replacer).asParameterized();
        return Optional.of(result);
    }

    public List<ParameterizedTypeView> interfaces() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type genericInterface : this.erasure().getGenericInterfaces()) {
            ParameterizedTypeView addedInterface = ParameterizedTypeView.of(genericInterface).replaceVariables(VariableReplacer.map(this.substitutions())).asParameterized();
            builder.add((Object)addedInterface);
        }
        return builder.build();
    }

    @Override
    @Deprecated
    public ParameterizedTypeView asParameterized() {
        return this;
    }

    @Override
    public ClassView<?> asClass() throws IllegalStateException {
        Type baseType = ((ParameterizedType)this.type).getRawType();
        Preconditions.checkState((boolean)(baseType instanceof Class), (String)"Base type is not a class, it's %s", (Object)baseType);
        ImmutableMap<TypeVariable<? extends Class<?>>, Type> substitutions = this.substitutions();
        Preconditions.checkState((boolean)substitutions.isEmpty(), (String)"There are substitutions defined in this type, %s", substitutions);
        Class rawType = (Class)baseType;
        return new ClassView(rawType);
    }

    @Override
    @Deprecated
    public TypeVariableView<?> asVariable() throws IllegalStateException {
        throw new IllegalStateException("Parameterized type cannot be converted to type variable");
    }

    @Override
    @Deprecated
    public WildcardTypeView asWildcard() throws IllegalStateException {
        throw new IllegalStateException("Parameterized type cannot be converted to wildcard type");
    }

    @Override
    public ArrayTypeView asArray() throws IllegalStateException {
        return this.asClass().asArray();
    }

    @Override
    public boolean isSubTypeOf(final TypeView other) {
        return other.visit(new TypeView.Visitor<Boolean>(){

            @Override
            public Boolean visitParameterized(ParameterizedTypeView view) {
                Class<?> thisRaw = ParameterizedTypeView.this.erasure();
                Class<?> otherRaw = view.erasure();
                if (!otherRaw.isAssignableFrom(thisRaw)) {
                    return false;
                }
                if (otherRaw.isArray()) {
                    return this.checkArray(thisRaw, TypeView.of(otherRaw.getComponentType()));
                }
                if (otherRaw.equals(thisRaw)) {
                    Iterator<TypeView> thisParameterIterator = ParameterizedTypeView.this.arguments().iterator();
                    Iterator<TypeView> otherParameterIterator = view.arguments().iterator();
                    while (thisParameterIterator.hasNext()) {
                        TypeView thisParameter = thisParameterIterator.next();
                        TypeView otherParameter = otherParameterIterator.next();
                        if (otherParameter.containsVariant(thisParameter)) continue;
                        return false;
                    }
                    return true;
                }
                return this.checkSupertypes(otherRaw, other);
            }

            @Override
            public Boolean visitClass(ClassView<?> view) {
                Type thisRaw = ((ParameterizedType)ParameterizedTypeView.this.type).getRawType();
                if (!view.isSuperTypeOf(thisRaw)) {
                    return false;
                }
                Class<?> otherRaw = view.erasure();
                if (otherRaw == Object.class) {
                    return true;
                }
                if (otherRaw.isArray()) {
                    if (!(thisRaw instanceof Class)) {
                        return false;
                    }
                    Class thisClass = (Class)thisRaw;
                    return this.checkArray(thisClass, TypeView.of(otherRaw.getComponentType()));
                }
                if (otherRaw.equals(thisRaw)) {
                    return true;
                }
                return this.checkSupertypes(otherRaw, other);
            }

            @Override
            public Boolean visitVariable(TypeVariableView<?> view) {
                return false;
            }

            @Override
            public Boolean visitWildcard(WildcardTypeView view) {
                return view.lowerBoundsStream().anyMatch(bound -> bound.isSuperTypeOf(ParameterizedTypeView.this.type));
            }

            @Override
            public Boolean visitArray(ArrayTypeView view) {
                Type thisRaw = ((ParameterizedType)ParameterizedTypeView.this.type).getRawType();
                if (!(thisRaw instanceof Class)) {
                    return false;
                }
                return this.checkArray((Class)thisRaw, view.component());
            }

            private boolean checkSupertypes(Class<?> otherRaw, TypeView other2) {
                Optional<ParameterizedTypeView> superclass = ParameterizedTypeView.this.superclass();
                Stream superStream = superclass.map(Stream::of).orElseGet(Stream::empty);
                Stream checked = otherRaw.isInterface() ? ParameterizedTypeView.this.interfaces().stream() : superStream;
                return checked.anyMatch(candidate -> candidate.isSubTypeOf(other2));
            }

            private boolean checkArray(Class<?> thisRaw, TypeView otherComponent) {
                return thisRaw.isArray() && ParameterizedTypeView.this.arguments().isEmpty() && otherComponent.isSuperTypeOf(thisRaw.getComponentType());
            }
        });
    }

    @Override
    public <T> T visit(TypeView.Visitor<T> visitor) {
        return visitor.visitParameterized(this);
    }

    @Override
    public ParameterizedTypeView resolve(Type other) {
        return (ParameterizedTypeView)super.resolve(other);
    }

    @Override
    public ParameterizedTypeView resolve(TypeView other) {
        return (ParameterizedTypeView)super.resolve(other);
    }

    @Override
    ParameterizedTypeView replaceVariables(VariableReplacer replacer) {
        Type[] actualArguments = ((ParameterizedType)this.type).getActualTypeArguments();
        Type[] updatedArguments = new Type[actualArguments.length];
        System.arraycopy(actualArguments, 0, updatedArguments, 0, actualArguments.length);
        for (int i = 0; i < actualArguments.length; ++i) {
            Type replacement;
            Type candidate = actualArguments[i];
            updatedArguments[i] = replacement = replacer.replacementFor(candidate);
        }
        SyntheticParameterizedType updated = new SyntheticParameterizedType((Class)((ParameterizedType)this.type).getRawType(), ((ParameterizedType)this.type).getOwnerType(), updatedArguments);
        return ParameterizedTypeView.of(updated);
    }

    @Override
    Type resolveVariable(TypeVariable<?> variable) {
        ImmutableMap<TypeVariable<? extends Class<?>>, Type> subs = this.substitutions();
        if (subs.containsKey(variable)) {
            return (Type)subs.get(variable);
        }
        for (ParameterizedTypeView genericInterface : this.interfaces()) {
            Type resolved = genericInterface.resolveVariable(variable);
            if (resolved.equals(variable)) continue;
            return resolved;
        }
        Optional<ParameterizedTypeView> genericSuperclass = this.superclass();
        if (genericSuperclass.isPresent()) {
            return genericSuperclass.get().resolveVariable(variable);
        }
        return variable;
    }

    private ImmutableMap<TypeVariable<? extends Class<?>>, Type> substitutions() {
        if (this.calculatedSubstitutions == null) {
            this.calculatedSubstitutions = ParameterizedTypeView.calculateSubstitutions((ParameterizedType)this.type);
        }
        return this.calculatedSubstitutions;
    }

    private static ImmutableMap<TypeVariable<? extends Class<?>>, Type> calculateSubstitutions(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        ImmutableMap.Builder substitutionsBuilder = ImmutableMap.builder();
        TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable typeParameter = typeParameters[i];
            Type actualTypeArgument = type.getActualTypeArguments()[i];
            if (actualTypeArgument.equals(typeParameter)) continue;
            substitutionsBuilder.put(typeParameter, (Object)actualTypeArgument);
        }
        return substitutionsBuilder.build();
    }

    private static ImmutableList<TypeView> calculateArguments(ParameterizedType type) {
        TypeVariable<Class<T>>[] parameterDeclarations = ((Class)type.getRawType()).getTypeParameters();
        Type[] actualArguments = type.getActualTypeArguments();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < parameterDeclarations.length; ++i) {
            Type actualArgument = actualArguments[i];
            TypeVariable parameter = parameterDeclarations[i];
            TypeView argumentView = ParameterizedTypeView.of(actualArgument).declaredAs(parameter);
            builder.add((Object)argumentView);
        }
        return builder.build();
    }
}

