/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

final class SyntheticParameterizedType
implements ParameterizedType {
    private final Class<?> rawType;
    @Nullable
    private final Type ownerType;
    private final Type[] typeArguments;

    SyntheticParameterizedType(Class<?> rawType, @Nullable Type ownerType, Type[] typeArguments) {
        Preconditions.checkArgument((typeArguments.length == rawType.getTypeParameters().length ? 1 : 0) != 0);
        this.rawType = rawType;
        this.ownerType = ownerType;
        this.typeArguments = (Type[])typeArguments.clone();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    @Nullable
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public String getTypeName() {
        String argumentNames = Stream.of(this.typeArguments).map(Type::getTypeName).collect(Collectors.joining(",", "<", ">"));
        return this.rawType.getTypeName() + argumentNames;
    }

    public String toString() {
        return this.getTypeName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        return this.rawType.equals(other.getRawType()) && Objects.equals(this.ownerType, other.getOwnerType()) && Arrays.equals(this.typeArguments, other.getActualTypeArguments());
    }

    public int hashCode() {
        return Objects.hash(this.rawType, this.ownerType, Arrays.hashCode(this.typeArguments));
    }
}

