/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SyntheticWildcardType
implements WildcardType {
    private static final Collector<CharSequence, ?, String> BOUND_JOINER = Collectors.joining(" & ");
    private final Type[] lowerBounds;
    private final Type[] upperBounds;

    SyntheticWildcardType(Type[] lowerBounds, Type[] upperBounds) {
        this.lowerBounds = (Type[])lowerBounds.clone();
        this.upperBounds = (Type[])upperBounds.clone();
    }

    @Override
    public Type[] getLowerBounds() {
        return (Type[])this.lowerBounds.clone();
    }

    @Override
    public Type[] getUpperBounds() {
        return (Type[])this.upperBounds.clone();
    }

    @Override
    public String getTypeName() {
        StringBuilder builder = new StringBuilder("?");
        if (this.lowerBounds.length > 0) {
            String lowerBoundsString = Stream.of(this.lowerBounds).map(Type::getTypeName).collect(BOUND_JOINER);
            builder.append(" super ").append(lowerBoundsString);
        }
        if (this.upperBounds.length > 0) {
            String upperBoundsString = Stream.of(this.upperBounds).map(Type::getTypeName).collect(BOUND_JOINER);
            builder.append(" extends ").append(upperBoundsString);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getTypeName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WildcardType)) {
            return false;
        }
        WildcardType other = (WildcardType)obj;
        return Arrays.equals(this.lowerBounds, other.getLowerBounds()) && Arrays.equals(this.upperBounds, other.getUpperBounds());
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.lowerBounds), Arrays.hashCode(this.upperBounds));
    }
}

