/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.perfectable.introspection.type.AbstractTypeView;
import org.perfectable.introspection.type.ArrayTypeView;
import org.perfectable.introspection.type.ClassView;
import org.perfectable.introspection.type.ParameterizedTypeView;
import org.perfectable.introspection.type.SyntheticTypeVariable;
import org.perfectable.introspection.type.TypeView;
import org.perfectable.introspection.type.VariableReplacer;
import org.perfectable.introspection.type.WildcardTypeView;

public final class TypeVariableView<D extends GenericDeclaration>
extends AbstractTypeView<TypeVariable<D>> {
    TypeVariableView(TypeVariable<D> type) {
        super(type);
    }

    public static <D extends GenericDeclaration> TypeVariableView<D> of(TypeVariable<D> variable) {
        return new TypeVariableView<D>(variable);
    }

    @Override
    public Class<?> erasure() {
        Type[] bounds = ((TypeVariable)this.type).getBounds();
        if (bounds.length == 0) {
            return Object.class;
        }
        Type firstBound = bounds[0];
        return TypeVariableView.of(firstBound).erasure();
    }

    public Collection<TypeView> upperBounds() {
        return this.upperBoundsStream().collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public ParameterizedTypeView asParameterized() throws IllegalStateException {
        throw new IllegalStateException("Type variable cannot be converted to parameterized view");
    }

    @Override
    @Deprecated
    public ClassView<?> asClass() throws IllegalStateException {
        throw new IllegalStateException("Type variable cannot be converted to class");
    }

    @Override
    @Deprecated
    public TypeVariableView<?> asVariable() {
        return this;
    }

    @Override
    @Deprecated
    public WildcardTypeView asWildcard() throws IllegalStateException {
        throw new IllegalStateException("Type variable cannot be converted to wildcard");
    }

    @Override
    @Deprecated
    public ArrayTypeView asArray() throws IllegalStateException {
        throw new IllegalStateException("Type variable cannot be converted to array type");
    }

    @Override
    public boolean isSubTypeOf(final TypeView other) {
        return other.visit(new TypeView.PartialVisitor<Boolean>(){

            @Override
            public Boolean visitVariable(TypeVariableView<?> view) {
                return ((TypeVariable)view.type).equals(TypeVariableView.this.type) || this.fallback() != false;
            }

            @Override
            public Boolean visitWildcard(WildcardTypeView view) {
                return view.lowerBoundsStream().allMatch(wildcardBound -> TypeVariableView.this.upperBoundsStream().anyMatch(bound -> bound.isSubTypeOf((TypeView)wildcardBound))) && view.upperBounds().isEmpty();
            }

            @Override
            protected Boolean fallback() {
                return TypeVariableView.this.upperBoundsStream().anyMatch(bound -> bound.isSubTypeOf(other));
            }
        });
    }

    @Override
    public <T> T visit(TypeView.Visitor<T> visitor) {
        return visitor.visitVariable(this);
    }

    @Override
    TypeView replaceVariables(VariableReplacer substitutions) {
        Type replaced = substitutions.replacementFor(this.type);
        if (!((TypeVariable)this.type).equals(replaced)) {
            return TypeVariableView.of(replaced);
        }
        Type[] originalBounds = ((TypeVariable)this.type).getBounds();
        Type[] updatedBounds = (Type[])((TypeVariable)this.type).getBounds().clone();
        boolean changed = false;
        for (int i = 0; i < originalBounds.length; ++i) {
            Type candidate = originalBounds[i];
            Type replacement = substitutions.replacementFor(candidate);
            if (candidate.equals(replacement)) continue;
            updatedBounds[i] = replacement;
            changed = true;
        }
        if (!changed) {
            return this;
        }
        SyntheticTypeVariable updated = new SyntheticTypeVariable(((TypeVariable)this.type).getName(), ((TypeVariable)this.type).getGenericDeclaration(), updatedBounds);
        return TypeVariableView.of(updated);
    }

    @Override
    Type resolveVariable(TypeVariable<?> variable) {
        return this.upperBoundsStream().map(bound -> bound.resolveVariable(variable)).filter(candidate -> !candidate.equals(variable)).findFirst().orElse(variable);
    }

    private Stream<TypeView> upperBoundsStream() {
        return Stream.of(((TypeVariable)this.type).getBounds()).map(TypeView::of);
    }
}

