/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;
import org.perfectable.introspection.type.ArrayTypeView;
import org.perfectable.introspection.type.ClassView;
import org.perfectable.introspection.type.ParameterizedTypeView;
import org.perfectable.introspection.type.SyntheticGenericArrayType;
import org.perfectable.introspection.type.TypeVariableView;
import org.perfectable.introspection.type.VariableReplacer;
import org.perfectable.introspection.type.WildcardTypeView;

public abstract class TypeView {
    public static TypeView of(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeView.of((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return TypeView.of((Class)type);
        }
        if (type instanceof TypeVariable) {
            return new TypeVariableView((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return new WildcardTypeView((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return TypeView.of((GenericArrayType)type);
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public static ParameterizedTypeView of(ParameterizedType parameterized) {
        return ParameterizedTypeView.of(parameterized);
    }

    public static <X> ClassView<X> of(Class<X> clazz) {
        return ClassView.of(clazz);
    }

    public static <D extends GenericDeclaration> TypeVariableView<D> of(TypeVariable<D> variable) {
        return TypeVariableView.of(variable);
    }

    public static WildcardTypeView of(WildcardType wildcard) {
        return WildcardTypeView.of(wildcard);
    }

    public static ArrayTypeView of(GenericArrayType genericArray) {
        return ArrayTypeView.of(genericArray);
    }

    public static TypeView ofTypeOf(Field field) {
        return TypeView.of(field.getGenericType());
    }

    public static TypeVariableView<Method> ofTypeParameterOf(Method method, int number) throws IllegalArgumentException {
        TypeVariable<Method> parameter = TypeView.safeAccessArray(method.getTypeParameters(), number);
        return TypeView.of(parameter);
    }

    public static TypeView ofParameterOf(Method method, int number) {
        Type parameter = TypeView.safeAccessArray(method.getGenericParameterTypes(), number);
        return TypeView.of(parameter);
    }

    TypeView() {
    }

    public abstract Type unwrap();

    public abstract Class<?> erasure();

    public abstract boolean isSubTypeOf(TypeView var1);

    public boolean isSubTypeOf(Type other) {
        return this.isSubTypeOf(TypeView.of(other));
    }

    public boolean isProperSubtypeOf(TypeView other) {
        return !this.equals(other) && this.isSubTypeOf(other);
    }

    public boolean isProperSubtypeOf(Type other) {
        return this.isProperSubtypeOf(TypeView.of(other));
    }

    public boolean isSuperTypeOf(TypeView other) {
        return other.isSubTypeOf(this);
    }

    public boolean isSuperTypeOf(Type other) {
        return this.isSuperTypeOf(TypeView.of(other));
    }

    public boolean isProperSupertypeOf(TypeView other) {
        return !this.equals(other) && this.isSuperTypeOf(other);
    }

    public boolean isProperSupertypeOf(Type other) {
        return this.isProperSupertypeOf(TypeView.of(other));
    }

    public boolean isInstance(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.isSuperTypeOf(element.getClass());
    }

    public abstract ParameterizedTypeView asParameterized() throws IllegalStateException;

    public abstract ClassView<?> asClass() throws IllegalStateException;

    public abstract TypeVariableView<?> asVariable() throws IllegalStateException;

    public abstract WildcardTypeView asWildcard() throws IllegalStateException;

    public abstract ArrayTypeView asArray() throws IllegalStateException;

    public TypeView resolve(Type other) {
        return this.resolve(TypeView.of(other));
    }

    public TypeView resolve(TypeView other) {
        VariableReplacer collector = VariableReplacer.view(other);
        return this.replaceVariables(collector);
    }

    public abstract <T> T visit(Visitor<T> var1);

    abstract TypeView replaceVariables(VariableReplacer var1);

    abstract Type resolveVariable(TypeVariable<?> var1);

    TypeView declaredAs(TypeVariable<?> parameter) {
        return this;
    }

    boolean containsVariant(TypeView other) {
        return this.equals(other);
    }

    ArrayTypeView makeArray() {
        SyntheticGenericArrayType arrayType = new SyntheticGenericArrayType(this.unwrap());
        return new ArrayTypeView(arrayType);
    }

    private static <T> T safeAccessArray(T[] elements, int number) {
        Preconditions.checkArgument((number >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((number < elements.length ? 1 : 0) != 0);
        return elements[number];
    }

    public static abstract class PartialVisitor<T>
    implements Visitor<T> {
        protected abstract T fallback();

        @Override
        public T visitParameterized(ParameterizedTypeView view) {
            return this.fallback();
        }

        @Override
        public T visitClass(ClassView<?> view) {
            return this.fallback();
        }

        @Override
        public T visitVariable(TypeVariableView<?> view) {
            return this.fallback();
        }

        @Override
        public T visitWildcard(WildcardTypeView view) {
            return this.fallback();
        }

        @Override
        public T visitArray(ArrayTypeView view) {
            return this.fallback();
        }
    }

    public static interface Visitor<T> {
        public T visitParameterized(ParameterizedTypeView var1);

        public T visitClass(ClassView<?> var1);

        public T visitVariable(TypeVariableView<?> var1);

        public T visitWildcard(WildcardTypeView var1);

        public T visitArray(ArrayTypeView var1);
    }
}

