/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.perfectable.introspection.type.TypeView;

interface VariableReplacer {
    public static VariableReplacer map(ImmutableMap<TypeVariable<? extends Class<?>>, Type> substitutions) {
        return new ForMap(substitutions);
    }

    public static VariableReplacer view(TypeView view) {
        return new ForView(view);
    }

    public Type replacementFor(Type var1);

    public static final class ForMap
    implements VariableReplacer {
        private final ImmutableMap<? extends TypeVariable<?>, Type> substitutions;

        ForMap(ImmutableMap<? extends TypeVariable<?>, Type> substitutions) {
            this.substitutions = substitutions;
        }

        @Override
        public Type replacementFor(Type type) {
            return (Type)this.substitutions.getOrDefault((Object)type, (Object)type);
        }
    }

    public static final class ForView
    implements VariableReplacer {
        private final TypeView source;
        private final Map<Type, Type> mapping = new HashMap<Type, Type>();

        ForView(TypeView source) {
            this.source = source;
        }

        @Override
        public Type replacementFor(Type type) {
            Type replacement;
            if (this.mapping.containsKey(type)) {
                return this.mapping.get(type);
            }
            if (type instanceof TypeVariable) {
                TypeVariable variable = (TypeVariable)type;
                replacement = this.source.resolveVariable(variable);
            } else {
                replacement = TypeView.of(type).replaceVariables(this).unwrap();
            }
            this.mapping.put(type, replacement);
            return replacement;
        }
    }
}

