/*
 * Decompiled with CFR 0.152.
 */
package org.perfectable.introspection.type;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.perfectable.introspection.type.AbstractTypeView;
import org.perfectable.introspection.type.ArrayTypeView;
import org.perfectable.introspection.type.ClassView;
import org.perfectable.introspection.type.ParameterizedTypeView;
import org.perfectable.introspection.type.SyntheticWildcardType;
import org.perfectable.introspection.type.TypeVariableView;
import org.perfectable.introspection.type.TypeView;
import org.perfectable.introspection.type.VariableReplacer;

public final class WildcardTypeView
extends AbstractTypeView<WildcardType> {
    WildcardTypeView(WildcardType type) {
        super(type);
    }

    public static WildcardTypeView of(WildcardType wildcard) {
        return new WildcardTypeView(wildcard);
    }

    @Override
    public Class<?> erasure() {
        Type[] bounds = ((WildcardType)this.type).getUpperBounds();
        Type firstBound = bounds[0];
        return WildcardTypeView.of(firstBound).erasure();
    }

    public Collection<TypeView> upperBounds() {
        return this.upperBoundsStream().collect(Collectors.toList());
    }

    public Collection<TypeView> lowerBounds() {
        return this.lowerBoundsStream().collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public ParameterizedTypeView asParameterized() throws IllegalStateException {
        throw new IllegalStateException("Wildcard type cannot be converted to parameterized view");
    }

    @Override
    @Deprecated
    public ClassView<?> asClass() throws IllegalStateException {
        throw new IllegalStateException("Wildcard type cannot be converted to class");
    }

    @Override
    @Deprecated
    public TypeVariableView<?> asVariable() {
        throw new IllegalStateException("Wildcard type cannot be converted to type variable");
    }

    @Override
    @Deprecated
    public WildcardTypeView asWildcard() {
        return this;
    }

    @Override
    @Deprecated
    public ArrayTypeView asArray() throws IllegalStateException {
        throw new IllegalStateException("Type variable cannot be converted to array type");
    }

    @Override
    public boolean isSubTypeOf(TypeView other) {
        return this.upperBoundsStream().anyMatch(bound -> bound.isSubTypeOf(other));
    }

    @Override
    public <T> T visit(TypeView.Visitor<T> visitor) {
        return visitor.visitWildcard(this);
    }

    @Override
    public WildcardTypeView resolve(Type other) {
        return (WildcardTypeView)super.resolve(other);
    }

    @Override
    public WildcardTypeView resolve(TypeView other) {
        return (WildcardTypeView)super.resolve(other);
    }

    @Override
    WildcardTypeView declaredAs(TypeVariable<?> declaration) {
        Type[] declarationBounds = WildcardTypeView.removeObjectClass(declaration.getBounds());
        Type[] wildcardBounds = WildcardTypeView.removeObjectClass(((WildcardType)this.type).getUpperBounds());
        ArrayList<Object> upperBounds = new ArrayList<Object>();
        for (Type declared : declarationBounds) {
            TypeView declaredView = WildcardTypeView.of(declared);
            if (declared instanceof Class) {
                if (!Stream.of(wildcardBounds).filter(w -> !(w instanceof Class)).noneMatch(declaredView::isSubTypeOf)) continue;
            }
            upperBounds.add(declared);
        }
        for (Type wildcardBound : wildcardBounds) {
            TypeView wildcardBoundView = WildcardTypeView.of(wildcardBound);
            if (wildcardBound instanceof Class) {
                if (!Stream.of(declarationBounds).filter(d -> !(d instanceof Class)).noneMatch(wildcardBoundView::isSubTypeOf)) continue;
            }
            upperBounds.add(wildcardBound);
        }
        if (upperBounds.isEmpty()) {
            upperBounds.add(Object.class);
        }
        Type[] upperBoundsArray = upperBounds.toArray(new Type[0]);
        SyntheticWildcardType resultType = new SyntheticWildcardType(((WildcardType)this.type).getLowerBounds(), upperBoundsArray);
        return WildcardTypeView.of(resultType);
    }

    @Override
    WildcardTypeView replaceVariables(VariableReplacer substitutions) {
        Object[] newLowerBounds = (Type[])this.lowerBoundsStream().map(bound -> bound.replaceVariables(substitutions)).map(TypeView::unwrap).toArray(Type[]::new);
        Object[] newUpperBounds = (Type[])this.upperBoundsStream().map(bound -> bound.replaceVariables(substitutions)).map(TypeView::unwrap).toArray(Type[]::new);
        if (Arrays.equals(((WildcardType)this.type).getLowerBounds(), newLowerBounds) && Arrays.equals(((WildcardType)this.type).getUpperBounds(), newUpperBounds)) {
            return this;
        }
        SyntheticWildcardType newWildcard = new SyntheticWildcardType((Type[])newLowerBounds, (Type[])newUpperBounds);
        return WildcardTypeView.of(newWildcard);
    }

    @Override
    Type resolveVariable(TypeVariable<?> variable) {
        return Stream.concat(this.upperBoundsStream(), this.lowerBoundsStream()).map(bound -> bound.resolveVariable(variable)).filter(candidate -> !candidate.equals(variable)).findFirst().orElse(variable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean containsVariant(TypeView other) {
        if (!this.lowerBoundsStream().allMatch(other::isSuperTypeOf)) return false;
        if (!this.upperBoundsStream().allMatch(other::isSubTypeOf)) return false;
        return true;
    }

    Stream<TypeView> lowerBoundsStream() {
        return Stream.of(((WildcardType)this.type).getLowerBounds()).map(TypeView::of);
    }

    Stream<TypeView> upperBoundsStream() {
        Type[] upperBounds = ((WildcardType)this.type).getUpperBounds();
        return Stream.of(upperBounds).map(TypeView::of);
    }

    private static Type[] removeObjectClass(Type[] upperBounds) {
        return (Type[])Stream.of(upperBounds).filter(bound -> !Object.class.equals(bound)).toArray(Type[]::new);
    }
}

