/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.dbupgrader;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.perfmon4j.dbupgrader.NoCloseDerbyDatabase;
import org.perfmon4j.dbupgrader.UpdateOrCreateDb;
import org.perfmon4j.dbupgrader.UpdaterUtil;

public class UpdateOrCreateDbTest
extends TestCase {
    private static String SCHEMA = "TEST";
    public static final String JDBC_URL = "jdbc:derby:memory:mydb";
    public static final String JDBC_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private Connection conn = null;

    public UpdateOrCreateDbTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        NoCloseDerbyDatabase.initLiquibaseNoCloseDerbyDatabase();
        this.conn = UpdaterUtil.createConnection((String)JDBC_DRIVER, null, (String)"jdbc:derby:memory:mydb;create=true", null, null);
        this.conn.setAutoCommit(true);
        this.executeUpdate("CREATE SCHEMA " + SCHEMA);
    }

    protected void tearDown() throws Exception {
        UpdaterUtil.closeNoThrow((Connection)this.conn);
        try {
            UpdaterUtil.createConnection((String)JDBC_DRIVER, null, (String)"jdbc:derby:memory:mydb;drop=true", null, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        NoCloseDerbyDatabase.deInitLiquibaseNoCloseDerbyDatabase();
        super.tearDown();
    }

    private static String rsRowToString(ResultSet rs) throws SQLException {
        Object result = "";
        ResultSetMetaData d = rs.getMetaData();
        int count = d.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            result = (String)result + d.getColumnLabel(i) + "=" + rs.getString(i) + "\r\n";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dumpQuery(Connection conn, String SQL) throws SQLException {
        Object result = "";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(SQL);
            while (rs.next()) {
                result = (String)result + UpdateOrCreateDbTest.rsRowToString(rs);
                result = (String)result + "*********************************************\r\n";
            }
        }
        catch (Throwable throwable) {
            UpdaterUtil.closeNoThrow(rs);
            UpdaterUtil.closeNoThrow((Statement)stmt);
            throw throwable;
        }
        UpdaterUtil.closeNoThrow((ResultSet)rs);
        UpdaterUtil.closeNoThrow((Statement)stmt);
        return result;
    }

    public void testPopulateDatabase() throws Exception {
        this.runUpdater(new String[0]);
        UpdateOrCreateDbTest.assertTrue((String)"Should have a P4JSystem table", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"P4JSystem"));
        System.out.println(UpdateOrCreateDbTest.dumpQuery(this.conn, "SELECT * FROM " + SCHEMA + ".DATABASECHANGELOG"));
        UpdateOrCreateDbTest.assertTrue((String)"Database change log should reflect databaseLabel 0002.0 applied", (boolean)this.databaseLabelExistsInChangeLog("0002.0"));
        int systemRows = this.getQueryCount("SELECT count(*) FROM " + SCHEMA + ".P4JSystem WHERE SystemID=1 AND SystemName='Default'");
        UpdateOrCreateDbTest.assertEquals((String)"Should have populated default system row", (int)1, (int)systemRows);
    }

    public void testVersion4Update() throws Exception {
        this.runUpdater(new String[0]);
        int count = this.getQueryCount("SELECT count(*) FROM " + SCHEMA + ".DATABASECHANGELOG WHERE author = 'databaseLabel' AND ID = '0004.0'");
        UpdateOrCreateDbTest.assertEquals((String)"should have installed 4.0 label", (int)1, (int)count);
        try {
            this.getQueryCount("SELECT count(*) FROM " + SCHEMA + ".P4JVMSnapshot WHERE systemCpuLoad > 1.0 AND processCpuLoad > 1.0");
        }
        catch (Exception ex) {
            UpdateOrCreateDbTest.fail((String)"Should have added systemCpuLoad and processCpuLoad columns to the P4JVMSnapshot table");
        }
    }

    public void testVersion5Update() throws Exception {
        this.runUpdater(new String[0]);
        int count = this.getQueryCount("SELECT count(*) FROM " + SCHEMA + ".DATABASECHANGELOG WHERE author = 'databaseLabel' AND ID = '0005.0'");
        UpdateOrCreateDbTest.assertEquals((String)"should have installed 5.0 label", (int)1, (int)count);
        try {
            count = this.getQueryCount("SELECT count(*) FROM " + SCHEMA + ".P4JDatabaseIdentity WHERE DatabaseID IS NOT NULL");
            UpdateOrCreateDbTest.assertEquals((String)"Should have populated database identity", (int)1, (int)count);
        }
        catch (Exception ex) {
            UpdateOrCreateDbTest.fail((String)"Should have added database identity table");
        }
    }

    public void testIntervalIDIsCreatedAsABigInt() throws Exception {
        this.runUpdater(new String[0]);
        String dataType = UpdaterUtil.getColumnDataType((Connection)this.conn, (String)SCHEMA, (String)"P4JIntervalData", (String)"IntervalID");
        UpdateOrCreateDbTest.assertEquals((String)"P4JIntervalData.IntervalID column should be a BIGINT", (String)"BIGINT", (String)dataType.toUpperCase());
        dataType = UpdaterUtil.getColumnDataType((Connection)this.conn, (String)SCHEMA, (String)"P4JIntervalThreshold", (String)"IntervalID");
        UpdateOrCreateDbTest.assertEquals((String)"P4JIntervalThreshold.IntervalID column should be a BIGINT", (String)"BIGINT", (String)dataType.toUpperCase());
    }

    public void testVersion6Update() throws Exception {
        this.runUpdater(new String[0]);
        int count = this.getQueryCount("SELECT count(*) FROM " + SCHEMA + ".DATABASECHANGELOG WHERE author = 'databaseLabel' AND ID = '0006.0'");
        UpdateOrCreateDbTest.assertEquals((String)"should have installed 6.0 label", (int)1, (int)count);
        boolean groupExists = UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"P4JGroup");
        boolean joinExists = UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"P4JGroupSystemJoin");
        UpdateOrCreateDbTest.assertTrue((String)"New P4JGroup table should exist", (boolean)groupExists);
        UpdateOrCreateDbTest.assertTrue((String)"New P4JGroupSystemJoin table should exist", (boolean)joinExists);
    }

    public void testVersion7Update_Hystrix() throws Exception {
        this.runUpdater(new String[0]);
        int count = this.getQueryCount("SELECT count(*) FROM " + SCHEMA + ".DATABASECHANGELOG WHERE author = 'databaseLabel' AND ID = '0007.0'");
        UpdateOrCreateDbTest.assertEquals((String)"should have installed 7.0 label", (int)1, (int)count);
        boolean hystrixKeyExists = UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"P4JGroup");
        boolean hystrixCommandExists = UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"P4JGroupSystemJoin");
        boolean hystrixThreadPoolExists = UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"P4JGroupSystemJoin");
        UpdateOrCreateDbTest.assertTrue((String)"New P4JHystrixKey table should exist", (boolean)hystrixKeyExists);
        UpdateOrCreateDbTest.assertTrue((String)"New P4JHystrixCommand table should exist", (boolean)hystrixCommandExists);
        UpdateOrCreateDbTest.assertTrue((String)"New P4JHystrixThreadPool table should exist", (boolean)hystrixThreadPoolExists);
    }

    public void testVersion7Update_Performance() throws Exception {
        this.runUpdater(new String[0]);
        UpdateOrCreateDbTest.assertTrue((String)"should have installed 7.0 label", (boolean)this.databaseLabelExistsInChangeLog("0007.0"));
        UpdateOrCreateDbTest.assertTrue((String)"Changelog entry created", (boolean)this.changeLogEntryExistsWithID("P4J-AddIndexesForP4JReports"));
        UpdateOrCreateDbTest.assertTrue((String)"Should have added control table", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"P4JAppenderControl"));
        UpdateOrCreateDbTest.assertTrue((String)"Should have added control table", (boolean)UpdaterUtil.doesColumnExist((Connection)this.conn, (String)SCHEMA, (String)"P4JAppenderControl", (String)"pauseAppenderMinutes"));
        UpdateOrCreateDbTest.assertTrue((String)"Changelog entry created", (boolean)this.changeLogEntryExistsWithID("P4J-CreateAppenderControlTable"));
        boolean indexExists = UpdaterUtil.doesIndexExist((Connection)this.conn, (String)SCHEMA, (String)"P4JIntervalData", (String)"P4JIntervalData_SystemEndTime");
        UpdateOrCreateDbTest.assertTrue((String)"New P4JIntervalData_SystemEndTime index should exist", (boolean)indexExists);
        boolean weGetPastProblemOfLiquibaseNotReleasingDatabaseLock = false;
        if (weGetPastProblemOfLiquibaseNotReleasingDatabaseLock) {
            this.deleteChangeLogEntyWithID("P4J-AddIndexesForP4JReports");
            UpdateOrCreateDbTest.assertFalse((String)"Make sure change log entry was deleted, this will cause Liquibase to run it again", (boolean)this.changeLogEntryExistsWithID("P4J-AddIndexesForP4JReports"));
            this.runUpdater(new String[0]);
            UpdateOrCreateDbTest.assertTrue((String)"P4JIntervalData_SystemEndTime entry should have been restored", (boolean)this.changeLogEntryExistsWithID("P4J-AddIndexesForP4JReports"));
        }
    }

    public void testParseParameters() throws Exception {
        String[] args = new String[]{"userName=dave", "password=pw", "jdbcURL=my.jdbc.url", "driverClass=myDriver", "driverJarFile=c:/mydriver.jar", "schema=dbo"};
        UpdateOrCreateDb.Parameters params = UpdateOrCreateDb.getParameters((String[])args);
        UpdateOrCreateDbTest.assertNotNull((Object)params);
        UpdateOrCreateDbTest.assertEquals((String)"dave", (String)params.getUserName());
        UpdateOrCreateDbTest.assertEquals((String)"pw", (String)params.getPassword());
        UpdateOrCreateDbTest.assertEquals((String)"my.jdbc.url", (String)params.getJdbcURL());
        UpdateOrCreateDbTest.assertEquals((String)"myDriver", (String)params.getDriverClass());
        UpdateOrCreateDbTest.assertEquals((String)"c:/mydriver.jar", (String)params.getDriverJarFile());
        UpdateOrCreateDbTest.assertEquals((String)"dbo", (String)params.getSchema());
        UpdateOrCreateDbTest.assertEquals((int)0, (int)params.getThirdPartyExtensions().length);
        UpdateOrCreateDbTest.assertTrue((boolean)params.isValid());
    }

    public void testParse3rdPartyIncludesMultiple() throws Exception {
        String[] args = new String[]{"userName=dave", "password=pw", "jdbcURL=my.jdbc.url", "driverClass=myDriver", "driverJarFile=c:/mydriver.jar", "schema=dbo", "thirdPartyExtensions=Follett,Other,YetAnother"};
        UpdateOrCreateDb.Parameters params = UpdateOrCreateDb.getParameters((String[])args);
        String[] thirdPartyExtensions = params.getThirdPartyExtensions();
        UpdateOrCreateDbTest.assertEquals((String)"Should have 3 thirdPartyExtensions", (int)3, (int)thirdPartyExtensions.length);
        List<String> extensions = Arrays.asList(thirdPartyExtensions);
        UpdateOrCreateDbTest.assertTrue((String)"Should have Follett Extension", (boolean)extensions.contains("Follett"));
        UpdateOrCreateDbTest.assertTrue((String)"Should have Other Extension", (boolean)extensions.contains("Other"));
        UpdateOrCreateDbTest.assertTrue((String)"Should have YetAnother Extension", (boolean)extensions.contains("YetAnother"));
    }

    public void testParse3rdPartyIncludesSingle() throws Exception {
        String[] args = new String[]{"userName=dave", "password=pw", "jdbcURL=my.jdbc.url", "driverClass=myDriver", "driverJarFile=c:/mydriver.jar", "schema=dbo", "thirdPartyExtensions=Follett"};
        UpdateOrCreateDb.Parameters params = UpdateOrCreateDb.getParameters((String[])args);
        String[] thirdPartyExtensions = params.getThirdPartyExtensions();
        UpdateOrCreateDbTest.assertEquals((String)"Should have 3 thirdPartyExtensions", (int)1, (int)thirdPartyExtensions.length);
        List<String> extensions = Arrays.asList(thirdPartyExtensions);
        UpdateOrCreateDbTest.assertTrue((String)"Should have Follett Extension", (boolean)extensions.contains("Follett"));
    }

    public void testInsufficientParameters() throws Exception {
        String[] args = new String[]{};
        UpdateOrCreateDb.Parameters params = UpdateOrCreateDb.getParameters((String[])args);
        UpdateOrCreateDbTest.assertTrue((String)"InsufficentParameters", (boolean)params.isInsufficentParameters());
        UpdateOrCreateDbTest.assertFalse((String)"isValid", (boolean)params.isValid());
    }

    public void testBadParameters() throws Exception {
        String[] args = new String[]{"userName=dave", "password=pw", "jdbcURL=my.jdbc.url", "driverClass=myDriver", "driverJarFile=c:/mydriver.jar", "somethingElse=5"};
        UpdateOrCreateDb.Parameters params = UpdateOrCreateDb.getParameters((String[])args);
        UpdateOrCreateDbTest.assertEquals((int)1, (int)params.getBadParameters().size());
        UpdateOrCreateDbTest.assertEquals((String)"somethingElse=5", (String)((String)params.getBadParameters().get(0)));
        UpdateOrCreateDbTest.assertFalse((boolean)params.isValid());
    }

    public void testInstallBaseChangeLogsVersion1Db() throws Exception {
        Statement stmt = null;
        try {
            this.applyChangeLog("org/perfmon4j/initial-change-log.xml");
            this.dropLiquibaseTables();
            UpdateOrCreateDbTest.assertFalse((String)"Make sure version 2.0 changes have not been applied", (boolean)UpdaterUtil.doesColumnExist((Connection)this.conn, (String)SCHEMA, (String)"P4JIntervalData", (String)"SQLMaxDuration"));
            this.runUpdater(new String[0]);
        }
        finally {
            UpdaterUtil.closeNoThrow(stmt);
        }
        UpdateOrCreateDbTest.assertTrue((String)"Should have a changelog", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"DATABASECHANGELOG"));
        UpdateOrCreateDbTest.assertTrue((String)"Should have applied version 2.0 changes", (boolean)UpdaterUtil.doesColumnExist((Connection)this.conn, (String)SCHEMA, (String)"P4JIntervalData", (String)"SQLMaxDuration"));
        UpdateOrCreateDbTest.assertTrue((String)"Database change log should reflect databaseLabel 0002.0 applied", (boolean)this.databaseLabelExistsInChangeLog("0002.0"));
    }

    public void testInstallBaseChangeLogsVersion2Db() throws Exception {
        Statement stmt = null;
        try {
            this.applyChangeLog("org/perfmon4j/initial-change-log.xml");
            this.applyChangeLog("org/perfmon4j/version-2-change-log.xml");
            this.dropLiquibaseTables();
            this.runUpdater(new String[0]);
        }
        finally {
            UpdaterUtil.closeNoThrow(stmt);
        }
        UpdateOrCreateDbTest.assertTrue((String)"Should have a changelog", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"DATABASECHANGELOG"));
        System.out.println(UpdateOrCreateDbTest.dumpQuery(this.conn, "SELECT * FROM " + SCHEMA + ".DATABASECHANGELOG"));
        UpdateOrCreateDbTest.assertTrue((String)"Database change log should reflect databaseLabel 0002.0 applied", (boolean)this.databaseLabelExistsInChangeLog("0002.0"));
    }

    public void testInstallBaseChangeLogsVersion3Db() throws Exception {
        Statement stmt = null;
        try {
            this.applyChangeLog("org/perfmon4j/initial-change-log.xml");
            this.applyChangeLog("org/perfmon4j/version-2-change-log.xml");
            this.applyChangeLog("org/perfmon4j/version-3-change-log.xml");
            this.dropLiquibaseTables();
            this.runUpdater(new String[0]);
        }
        finally {
            UpdaterUtil.closeNoThrow(stmt);
        }
        UpdateOrCreateDbTest.assertTrue((String)"Should have a changelog", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"DATABASECHANGELOG"));
        System.out.println(UpdateOrCreateDbTest.dumpQuery(this.conn, "SELECT * FROM " + SCHEMA + ".DATABASECHANGELOG"));
        UpdateOrCreateDbTest.assertTrue((String)"Database change log should reflect databaseLabel 0003.0 applied", (boolean)this.databaseLabelExistsInChangeLog("0003.0"));
    }

    public void testApplyThirdPartyChanges() throws Exception {
        this.runUpdater("thirdPartyExtensions=FSS");
        UpdateOrCreateDbTest.assertTrue((String)"Should have a FSSFetchThreadPoolSnapshot table", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"FSSFetchThreadPoolSnapshot"));
        UpdateOrCreateDbTest.assertTrue((String)"Should have a FSSFetchPolicySnapshot table", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"FSSFetchPolicySnapshot"));
        UpdateOrCreateDbTest.assertTrue((String)"Database change log should reflect databaseLabel 0002.0 applied", (boolean)this.databaseLabelExistsInChangeLog("0002.0"));
    }

    public void testWriteSQLScript() throws Exception {
        File sqlFile = new File(System.getProperty("java.io.tmpdir"), new Random().nextInt(10000) + ".sql");
        try {
            System.out.println(sqlFile.getCanonicalPath());
            this.runUpdater("thirdPartyExtensions=FSS", "sqlOutputScript=" + sqlFile.getCanonicalPath());
            UpdateOrCreateDbTest.assertFalse((String)"Should NOT have created database.  We just asked for a srcipt", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)SCHEMA, (String)"FSSFetchPolicySnapshot"));
            UpdateOrCreateDbTest.assertTrue((String)"Should have created SQL Script", (boolean)sqlFile.exists());
        }
        finally {
            if (sqlFile.exists()) {
                sqlFile.delete();
            }
        }
    }

    public void X_testLivePostgres() {
        String[] args = new String[]{"driverJarFile=/home/perfmon/host/tools/common/JDBCDrivers/postgresql-9.3-1102.jdbc4.jar", "driverClass=org.postgresql.Driver", "jdbcURL=jdbc:postgresql://10.0.2.2:15432/TestUpgrade", "userName=perfmonwriter", "password=perfmon"};
        UpdateOrCreateDb.main((String[])args);
    }

    public void X_testLiveSQLServer() {
        DatabaseFactory.reset();
        String[] args = new String[]{"driverJarFile=/media/sf_shared/tools/common/JDBCDrivers/sqljdbc4.jar", "driverClass=com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbcURL=jdbc:sqlserver://10.0.2.2:1433;databaseName=TestUpgrade", "userName=perfmonwriter", "password=perfmon", "thirdPartyExtensions=FSS", "sqlOutputScript=/media/sf_shared/tools/common/create.sql"};
        UpdateOrCreateDb.main((String[])args);
    }

    public void X_testLiveMySQL() {
        String[] args = new String[]{"driverJarFile=/home/perfmon/jdbc-drivers/mysql-connector-java-5.1.32-bin.jar", "driverClass=com.mysql.jdbc.Driver", "jdbcURL=jdbc:mysql://localhost:3306/TestUpgrade", "userName=perfmonwriter", "password=perfmon"};
        UpdateOrCreateDb.main((String[])args);
    }

    public void X_testLiveOracle() {
        String[] args = new String[]{"driverJarFile=/home/perfmon/host/tools/common/JDBCDrivers/ojdbc6.jar", "driverClass=oracle.jdbc.driver.OracleDriver", "jdbcURL=jdbc:oracle:thin:@10.0.2.2:1521/xe", "userName=perfmonwriter", "password=perfmon", "clearChecksums=true"};
        UpdateOrCreateDb.main((String[])args);
    }

    private void runUpdater(String ... extraParameters) throws Exception {
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList("driverClass=org.apache.derby.jdbc.EmbeddedDriver", "jdbcURL=jdbc:derby:memory:mydb", "driverJarFile=EMBEDDED", "schema=" + SCHEMA));
        parameters.addAll(Arrays.asList(extraParameters));
        UpdateOrCreateDb.main((String[])parameters.toArray(new String[0]));
    }

    private Database buildLiquibaseDatabaseConnection() throws Exception {
        return this.buildLiquibaseDatabaseConnection(JDBC_URL);
    }

    private Database buildLiquibaseDatabaseConnection(String jdbcURL) throws Exception {
        Connection tmpConn = UpdaterUtil.createConnection((String)JDBC_DRIVER, null, (String)jdbcURL, null, null);
        Database db = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(tmpConn));
        db.setDefaultSchemaName(SCHEMA);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChangeLog(String changeLog) throws Exception {
        try (Database db = this.buildLiquibaseDatabaseConnection();){
            Liquibase updater = new Liquibase(changeLog, (ResourceAccessor)new ClassLoaderResourceAccessor(), db);
            updater.update((String)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean databaseLabelExistsInChangeLog(String label) throws Exception {
        boolean result = false;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM " + SCHEMA + ".DATABASECHANGELOG WHERE ID='" + label + "' AND AUTHOR='databaseLabel'");
            result = rs.next();
        }
        catch (Throwable throwable) {
            UpdaterUtil.closeNoThrow(rs);
            UpdaterUtil.closeNoThrow((Statement)stmt);
            throw throwable;
        }
        UpdaterUtil.closeNoThrow((ResultSet)rs);
        UpdaterUtil.closeNoThrow((Statement)stmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeLogEntryExistsWithID(String changeLogID) throws Exception {
        boolean result = false;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM " + SCHEMA + ".DATABASECHANGELOG WHERE ID='" + changeLogID + "'");
            result = rs.next();
        }
        catch (Throwable throwable) {
            UpdaterUtil.closeNoThrow(rs);
            UpdaterUtil.closeNoThrow((Statement)stmt);
            throw throwable;
        }
        UpdaterUtil.closeNoThrow((ResultSet)rs);
        UpdaterUtil.closeNoThrow((Statement)stmt);
        return result;
    }

    private void deleteChangeLogEntyWithID(String changeLogID) throws Exception {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.executeUpdate("DELETE FROM " + SCHEMA + ".DATABASECHANGELOG WHERE ID='" + changeLogID + "'");
        }
        finally {
            UpdaterUtil.closeNoThrow((Statement)stmt);
        }
    }

    private void executeUpdate(String sql) throws Exception {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.executeUpdate(sql);
        }
        finally {
            UpdaterUtil.closeNoThrow((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getQueryCount(String query) throws Exception {
        int result = 0;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            result = rs.getInt(1);
        }
        catch (Throwable throwable) {
            UpdaterUtil.closeNoThrow(rs);
            UpdaterUtil.closeNoThrow((Statement)stmt);
            throw throwable;
        }
        UpdaterUtil.closeNoThrow((ResultSet)rs);
        UpdaterUtil.closeNoThrow((Statement)stmt);
        return result;
    }

    private void dumpChangeLog() throws Exception {
        System.out.println(UpdateOrCreateDbTest.dumpQuery(this.conn, "SELECT * FROM " + SCHEMA + ".DATABASECHANGELOG"));
    }

    private void dropLiquibaseTables() throws Exception {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.execute("DROP TABLE " + SCHEMA + ".DATABASECHANGELOG");
        }
        finally {
            UpdaterUtil.closeNoThrow((Statement)stmt);
        }
    }
}

