/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.dbupgrader;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import junit.framework.TestCase;
import org.perfmon4j.dbupgrader.UpdaterUtil;
import org.slf4j.LoggerFactory;

public class UpdaterUtilTest
extends TestCase {
    public static final String JDBC_URL = "jdbc:derby:memory:mydb";
    public static final String JDBC_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private Connection conn;

    public UpdaterUtilTest(String name) {
        super(name);
        Logger logger = (Logger)LoggerFactory.getLogger((String)"liquibase");
        logger.setLevel(Level.WARN);
        logger = (Logger)LoggerFactory.getLogger((String)"org.perfmon4j");
        logger.setLevel(Level.WARN);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.conn = UpdaterUtil.createConnection((String)JDBC_DRIVER, null, (String)"jdbc:derby:memory:mydb;create=true", null, null);
    }

    protected void tearDown() throws Exception {
        UpdaterUtil.closeNoThrow((Connection)this.conn);
        try {
            UpdaterUtil.createConnection((String)JDBC_DRIVER, null, (String)"jdbc:derby:memory:mydb;drop=true", null, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testTableExist() throws Exception {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.execute("CREATE TABLE MyTable(ID int)");
            UpdaterUtilTest.assertTrue((String)"Default schema and correct table name should match", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, null, (String)"MyTable"));
            UpdaterUtilTest.assertTrue((String)"Explicit schema name and correct table name should match", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)"app", (String)"MyTable"));
            UpdaterUtilTest.assertFalse((String)"Incorrect schema and correct table name should NOT match", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)"db", (String)"MyTable"));
            UpdaterUtilTest.assertFalse((String)"Default schema and incorrect table name should NOT match", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, null, (String)"MyOtherTable"));
            UpdaterUtilTest.assertFalse((String)"Explicit schema name and incorrect table name should NOT match", (boolean)UpdaterUtil.doesTableExist((Connection)this.conn, (String)"app", (String)"MyOtherTable"));
        }
        finally {
            UpdaterUtil.closeNoThrow((Statement)stmt);
        }
    }

    public void testColumnExist() throws Exception {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.execute("CREATE TABLE MyTable(ID int)");
            UpdaterUtilTest.assertTrue((String)"Correct column", (boolean)UpdaterUtil.doesColumnExist((Connection)this.conn, null, (String)"MyTable", (String)"ID"));
            UpdaterUtilTest.assertFalse((String)"incorrect column", (boolean)UpdaterUtil.doesColumnExist((Connection)this.conn, null, (String)"MyTable", (String)"NotID"));
        }
        finally {
            UpdaterUtil.closeNoThrow((Statement)stmt);
        }
    }

    public void testIndexExists() throws Exception {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.execute("CREATE TABLE MyTable(ID int, count int)");
            stmt.execute("CREATE INDEX MyIndex ON MyTable(count)");
            UpdaterUtilTest.assertTrue((String)"Correct Index", (boolean)UpdaterUtil.doesIndexExist((Connection)this.conn, null, (String)"MyTable", (String)"MyIndex"));
            UpdaterUtilTest.assertFalse((String)"Incorrect Index", (boolean)UpdaterUtil.doesIndexExist((Connection)this.conn, null, (String)"MyTable", (String)"SomeOtherMyIndex"));
        }
        finally {
            UpdaterUtil.closeNoThrow((Statement)stmt);
        }
    }

    public void testGenerateUniqueIdentity() throws Exception {
        String identity = UpdaterUtil.generateUniqueIdentity();
        UpdaterUtilTest.assertNotNull((String)"Should have created and Identity", (Object)identity);
        UpdaterUtilTest.assertTrue((String)"Should match pattern", (boolean)identity.matches("[A-Z]{4}-[A-Z]{4}"));
        HashSet<String> identities = new HashSet<String>();
        int numToCreate = 20000;
        for (int i = 0; i < 20000; ++i) {
            identity = UpdaterUtil.generateUniqueIdentity();
            identities.add(identity);
        }
        UpdaterUtilTest.assertEquals((String)"Should never create a duplicate identity", (int)20000, (int)identities.size());
    }
}

