/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.extras.tomcat55;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.perfmon4j.SnapShotData;
import org.perfmon4j.SnapShotSQLWriter;
import org.perfmon4j.extras.tomcat55.GlobalRequestProcessorMonitor;
import org.perfmon4j.extras.tomcat55.JMXMonitorBase;
import org.perfmon4j.instrument.SnapShotCounter;
import org.perfmon4j.instrument.SnapShotInstanceDefinition;
import org.perfmon4j.instrument.SnapShotProvider;
import org.perfmon4j.instrument.SnapShotString;
import org.perfmon4j.util.ByteFormatter;
import org.perfmon4j.util.JDBCHelper;
import org.perfmon4j.util.Logger;
import org.perfmon4j.util.LoggerFactory;
import org.perfmon4j.util.MiscHelper;

@SnapShotProvider(type=SnapShotProvider.Type.INSTANCE_PER_MONITOR, dataInterface=GlobalRequestProcessorMonitor.class, sqlWriter=SQLWriter.class)
public class GlobalRequestProcessorMonitorImpl
extends JMXMonitorBase {
    private static final Logger logger = LoggerFactory.initLogger(GlobalRequestProcessorMonitorImpl.class);

    private static String buildBaseObjectName() {
        String result = "Catalina:type=GlobalRequestProcessor";
        if (MiscHelper.isRunningInJBossAppServer()) {
            result = "jboss.web:type=GlobalRequestProcessor";
        }
        return result;
    }

    public GlobalRequestProcessorMonitorImpl() {
        super(GlobalRequestProcessorMonitorImpl.buildBaseObjectName(), "name", null);
    }

    public GlobalRequestProcessorMonitorImpl(String instanceName) {
        super(GlobalRequestProcessorMonitorImpl.buildBaseObjectName(), "name", instanceName);
    }

    @SnapShotInstanceDefinition
    public static String[] getInstanceNames() throws MalformedObjectNameException, NullPointerException {
        MBeanServer mBeanServer = MiscHelper.findMBeanServer((String)(MiscHelper.isRunningInJBossAppServer() ? "jboss" : null));
        return MiscHelper.getAllObjectName((MBeanServer)mBeanServer, (ObjectName)new ObjectName(GlobalRequestProcessorMonitorImpl.buildBaseObjectName()), (String)"name");
    }

    @SnapShotString(isInstanceName=true)
    public String getInstanceName() {
        return MiscHelper.getInstanceNames((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"name");
    }

    @SnapShotCounter(preferredDisplay=SnapShotCounter.Display.DELTA_PER_MIN)
    public long getRequestCount() {
        return MiscHelper.sumMBeanAttributes((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"requestCount");
    }

    @SnapShotCounter(formatter=ByteFormatter.class, preferredDisplay=SnapShotCounter.Display.DELTA_PER_MIN)
    public long getBytesSent() {
        return MiscHelper.sumMBeanAttributes((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"bytesSent");
    }

    @SnapShotCounter(formatter=ByteFormatter.class, preferredDisplay=SnapShotCounter.Display.DELTA_PER_MIN)
    public long getBytesReceived() {
        return MiscHelper.sumMBeanAttributes((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"bytesReceived");
    }

    @SnapShotCounter(preferredDisplay=SnapShotCounter.Display.DELTA_PER_MIN)
    public long getProcessingTimeMillis() {
        return MiscHelper.sumMBeanAttributes((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"processingTime");
    }

    @SnapShotCounter(preferredDisplay=SnapShotCounter.Display.DELTA_PER_MIN)
    public long getErrorCount() {
        return MiscHelper.sumMBeanAttributes((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"errorCount");
    }

    public static class SQLWriter
    implements SnapShotSQLWriter {
        public void writeToSQL(Connection conn, String schema, SnapShotData data, long systemID) throws SQLException {
            this.writeToSQL(conn, schema, (GlobalRequestProcessorMonitor)data, systemID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToSQL(Connection conn, String schema, GlobalRequestProcessorMonitor data, long systemID) throws SQLException {
            schema = schema == null ? "" : (String)schema + ".";
            String SQL = "INSERT INTO " + (String)schema + "P4JGlobalRequestProcessor  (SystemID, InstanceName, StartTime, EndTime, Duration,  RequestCountInPeriod, RequestCountPerMinute, KBytesSentInPeriod,  KBytesSentPerMinute, KBytesReceivedInPeriod, KBytesReceivedPerMinute,  ProcessingMillisInPeriod, ProcessingMillisPerMinute, ErrorCountInPeriod,  ErrorCountPerMinute)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement(SQL);
                int index = 1;
                stmt.setLong(index++, systemID);
                stmt.setString(index++, data.getInstanceName());
                stmt.setTimestamp(index++, new Timestamp(data.getStartTime()));
                stmt.setTimestamp(index++, new Timestamp(data.getEndTime()));
                stmt.setLong(index++, data.getDuration());
                stmt.setLong(index++, data.getRequestCount().getDelta());
                stmt.setDouble(index++, data.getRequestCount().getDeltaPerMinute());
                stmt.setLong(index++, data.getBytesSent().getDelta() / 1024L);
                stmt.setDouble(index++, data.getBytesSent().getDeltaPerMinute() / 1024.0);
                stmt.setLong(index++, data.getBytesReceived().getDelta() / 1024L);
                stmt.setDouble(index++, data.getBytesReceived().getDeltaPerMinute() / 1024.0);
                stmt.setLong(index++, data.getProcessingTimeMillis().getDelta());
                stmt.setDouble(index++, data.getProcessingTimeMillis().getDeltaPerMinute());
                stmt.setLong(index++, data.getErrorCount().getDelta());
                stmt.setDouble(index++, data.getErrorCount().getDeltaPerMinute());
                int count = stmt.executeUpdate();
                if (count != 1) {
                    throw new SQLException("GlobalRequestProcessor failed to insert row");
                }
            }
            finally {
                JDBCHelper.closeNoThrow((Statement)stmt);
            }
        }
    }
}

