/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.extras.tomcat55;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.perfmon4j.util.MiscHelper;

public abstract class JMXMonitorBase {
    private final MBeanServer mBeanServer;
    private final ObjectName queryObjectName;
    private String domainName = null;

    public JMXMonitorBase(String baseObjectName, String instanceNameKey, String instanceNameValue) {
        Object instanceName = "," + instanceNameKey + "=" + instanceNameValue;
        if (instanceNameValue == null || "".equals(instanceNameValue)) {
            instanceName = ",*";
        }
        this.mBeanServer = MiscHelper.findMBeanServer((String)(MiscHelper.isRunningInJBossAppServer() ? "jboss" : null));
        if (this.mBeanServer == null) {
            throw new RuntimeException("Unable to find mBeanServer");
        }
        try {
            this.queryObjectName = new ObjectName(baseObjectName + (String)instanceName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Unable to format object name", e);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public ObjectName getQueryObjectName() {
        return this.queryObjectName;
    }
}

