/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.extras.tomcat55;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.perfmon4j.util.Logger;
import org.perfmon4j.util.LoggerFactory;
import web.org.perfmon4j.servlet.PerfMonFilter;
import web.org.perfmon4j.servlet.PerfMonNDCFilter;

public class PerfMonValve
extends ValveBase
implements Lifecycle {
    private static final Logger logger = LoggerFactory.initLogger(PerfMonValve.class);
    private final List<LifecycleListener> listeners = new ArrayList<LifecycleListener>();
    private final FilterChain filterChain = new FilterChainImpl((Valve)this);
    private PerfMonFilter filter = null;
    private String baseFilterCategory = "WebRequest";
    private boolean abortTimerOnRedirect = false;
    private boolean abortTimerOnImageResponse = false;
    private String abortTimerOnURLPattern = null;
    private String skipTimerOnURLPattern = null;
    private boolean outputRequestAndDuration = false;
    private String pushCookiesOnNDC = null;
    private String pushSessionAttributesOnNDC = null;
    private boolean pushClientInfoOnNDC = false;
    private String servletPathTransformationPattern = null;

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.filter != null && request instanceof ServletRequest && response instanceof ServletResponse) {
            this.filter.doFilter((ServletRequest)request, (ServletResponse)response, this.filterChain);
        } else {
            this.getNext().invoke(request, response);
        }
    }

    public void start() throws LifecycleException {
        try {
            FilterConfigImpl filterConfig = new FilterConfigImpl();
            filterConfig.setInitParameter("BASE_FILTER_CATEGORY", this.getBaseFilterCategory());
            filterConfig.setInitParameter("ABORT_TIMER_ON_REDIRECT", Boolean.toString(this.isAbortTimerOnRedirect()));
            filterConfig.setInitParameter("ABORT_TIMER_ON_IMAGE_RESPONSE", Boolean.toString(this.isAbortTimerOnImageResponse()));
            filterConfig.setInitParameter("ABORT_TIMER_ON_URL_PATTERN", this.getAbortTimerOnURLPattern());
            filterConfig.setInitParameter("SKIP_TIMER_ON_URL_PATTERN", this.getSkipTimerOnURLPattern());
            filterConfig.setInitParameter("SERVLET_PATH_TRANSFORMATION_PATTERN", this.getServletPathTransformationPattern());
            filterConfig.setInitParameter("OUTPUT_REQUEST_AND_DURATION", Boolean.toString(this.isOutputRequestAndDuration()));
            filterConfig.setInitParameter("NDC_PUSH_CLIENT_INFO", Boolean.toString(this.isPushClientInfoOnNDC()));
            filterConfig.setInitParameter("NDC_PUSH_COOKIES", this.getPushCookiesOnNDC());
            filterConfig.setInitParameter("NDC_PUSH_SESSION_ATTRIBUTES", this.getPushSessionAttributesOnNDC());
            this.filter = new PerfMonNDCFilter(true);
            this.filter.init((FilterConfig)filterConfig);
            logger.logInfo(((Object)((Object)this)).getClass().getSimpleName() + " started.");
            this.notifyListeners("start");
        }
        catch (ServletException e) {
            throw new LifecycleException("Error starting " + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        this.filter.destroy();
        this.filter = null;
        logger.logInfo(((Object)((Object)this)).getClass().getSimpleName() + " stopped.");
        this.notifyListeners("stop");
    }

    public String getBaseFilterCategory() {
        return this.baseFilterCategory;
    }

    public void setBaseFilterCategory(String baseFilterCategory) {
        this.baseFilterCategory = baseFilterCategory;
    }

    public boolean isAbortTimerOnRedirect() {
        return this.abortTimerOnRedirect;
    }

    public void setAbortTimerOnRedirect(boolean abortTimerOnRedirect) {
        this.abortTimerOnRedirect = abortTimerOnRedirect;
    }

    public boolean isAbortTimerOnImageResponse() {
        return this.abortTimerOnImageResponse;
    }

    public void setAbortTimerOnImageResponse(boolean abortTimerOnImageResponse) {
        this.abortTimerOnImageResponse = abortTimerOnImageResponse;
    }

    public String getAbortTimerOnURLPattern() {
        return this.abortTimerOnURLPattern;
    }

    public boolean isOutputRequestAndDuration() {
        return this.outputRequestAndDuration;
    }

    public void setOutputRequestAndDuration(boolean outputRequestAndDuration) {
        this.outputRequestAndDuration = outputRequestAndDuration;
    }

    public void setAbortTimerOnURLPattern(String abortTimerOnURLPattern) {
        this.abortTimerOnURLPattern = abortTimerOnURLPattern;
    }

    public String getPushCookiesOnNDC() {
        return this.pushCookiesOnNDC;
    }

    public void setPushCookiesOnNDC(String pushCookiesOnNDC) {
        this.pushCookiesOnNDC = pushCookiesOnNDC;
    }

    public String getPushSessionAttributesOnNDC() {
        return this.pushSessionAttributesOnNDC;
    }

    public void setPushSessionAttributesOnNDC(String pushSessionAttributesOnNDC) {
        this.pushSessionAttributesOnNDC = pushSessionAttributesOnNDC;
    }

    public boolean isPushClientInfoOnNDC() {
        return this.pushClientInfoOnNDC;
    }

    public void setPushClientInfoOnNDC(boolean pushClientInfoOnNDC) {
        this.pushClientInfoOnNDC = pushClientInfoOnNDC;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    public String getSkipTimerOnURLPattern() {
        return this.skipTimerOnURLPattern;
    }

    public void setSkipTimerOnURLPattern(String skipTimerOnURLPattern) {
        this.skipTimerOnURLPattern = skipTimerOnURLPattern;
    }

    public String getServletPathTransformationPattern() {
        return this.servletPathTransformationPattern;
    }

    public void setServletPathTransformationPattern(String servletPathTransformationPattern) {
        this.servletPathTransformationPattern = servletPathTransformationPattern;
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.listeners.toArray(new LifecycleListener[this.listeners.size()]);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(String eventType) {
        LifecycleEvent event = new LifecycleEvent((Lifecycle)this, eventType);
        Iterator<LifecycleListener> itr = this.listeners.iterator();
        while (itr.hasNext()) {
            itr.next().lifecycleEvent(event);
        }
    }

    private static class FilterConfigImpl
    implements FilterConfig {
        private final Properties initParameters = new Properties();

        private FilterConfigImpl() {
        }

        public String getFilterName() {
            return "PerfMonValve";
        }

        public String getInitParameter(String key) {
            return this.initParameters.getProperty(key);
        }

        public Enumeration getInitParameterNames() {
            return null;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public void setInitParameter(String key, String value) {
            if (value == null) {
                this.initParameters.remove(key);
            } else {
                logger.logInfo(this.getClass().getSimpleName() + " " + key + "=" + value);
                this.initParameters.setProperty(key, value);
            }
        }
    }

    private static class FilterChainImpl
    implements FilterChain {
        private final Valve valve;

        public FilterChainImpl(Valve valve) {
            this.valve = valve;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            this.valve.getNext().invoke((Request)request, (Response)response);
        }
    }
}

