/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.extras.tomcat55;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.perfmon4j.SnapShotData;
import org.perfmon4j.SnapShotSQLWriter;
import org.perfmon4j.extras.tomcat55.JMXMonitorBase;
import org.perfmon4j.extras.tomcat55.ThreadPoolMonitor;
import org.perfmon4j.instrument.SnapShotGauge;
import org.perfmon4j.instrument.SnapShotInstanceDefinition;
import org.perfmon4j.instrument.SnapShotProvider;
import org.perfmon4j.instrument.SnapShotString;
import org.perfmon4j.util.JDBCHelper;
import org.perfmon4j.util.Logger;
import org.perfmon4j.util.LoggerFactory;
import org.perfmon4j.util.MiscHelper;

@SnapShotProvider(type=SnapShotProvider.Type.INSTANCE_PER_MONITOR, dataInterface=ThreadPoolMonitor.class, sqlWriter=SQLWriter.class)
public class ThreadPoolMonitorImpl
extends JMXMonitorBase {
    private static final Logger logger = LoggerFactory.initLogger(ThreadPoolMonitorImpl.class);

    private static String buildBaseObjectName() {
        String result = "Catalina:type=ThreadPool";
        if (MiscHelper.isRunningInJBossAppServer()) {
            result = "jboss.web:type=ThreadPool";
        }
        return result;
    }

    public ThreadPoolMonitorImpl() {
        super(ThreadPoolMonitorImpl.buildBaseObjectName(), "name", null);
    }

    public ThreadPoolMonitorImpl(String instanceName) {
        super(ThreadPoolMonitorImpl.buildBaseObjectName(), "name", instanceName);
    }

    @SnapShotInstanceDefinition
    public static String[] getInstanceNames() throws MalformedObjectNameException, NullPointerException {
        MBeanServer mBeanServer = MiscHelper.findMBeanServer((String)(MiscHelper.isRunningInJBossAppServer() ? "jboss" : null));
        return MiscHelper.getAllObjectName((MBeanServer)mBeanServer, (ObjectName)new ObjectName(ThreadPoolMonitorImpl.buildBaseObjectName()), (String)"name");
    }

    @SnapShotString(isInstanceName=true)
    public String getInstanceName() {
        return MiscHelper.getInstanceNames((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"name");
    }

    @SnapShotGauge
    public long getCurrentThreadsBusy() {
        return MiscHelper.sumMBeanAttributes((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"currentThreadsBusy");
    }

    @SnapShotGauge
    public long getCurrentThreadCount() {
        return MiscHelper.sumMBeanAttributes((MBeanServer)this.getMBeanServer(), (ObjectName)this.getQueryObjectName(), (String)"currentThreadCount");
    }

    public static class SQLWriter
    implements SnapShotSQLWriter {
        public void writeToSQL(Connection conn, String schema, SnapShotData data, long systemID) throws SQLException {
            this.writeToSQL(conn, schema, (ThreadPoolMonitor)data, systemID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToSQL(Connection conn, String schema, ThreadPoolMonitor data, long systemID) throws SQLException {
            schema = schema == null ? "" : (String)schema + ".";
            String SQL = "INSERT INTO " + (String)schema + "P4JThreadPoolMonitor (SystemID, ThreadPoolOwner, InstanceName, StartTime, EndTime, Duration,  CurrentThreadsBusy, CurrentThreadCount) VALUES(?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement(SQL);
                int index = 1;
                stmt.setLong(index++, systemID);
                stmt.setString(index++, "Apache/Tomcat");
                stmt.setString(index++, data.getInstanceName());
                stmt.setTimestamp(index++, new Timestamp(data.getStartTime()));
                stmt.setTimestamp(index++, new Timestamp(data.getEndTime()));
                stmt.setLong(index++, data.getDuration());
                stmt.setLong(index++, data.getCurrentThreadsBusy());
                stmt.setLong(index++, data.getCurrentThreadCount());
                int count = stmt.executeUpdate();
                if (count != 1) {
                    throw new SQLException("ThreadPoolMonitor failed to insert row");
                }
            }
            finally {
                JDBCHelper.closeNoThrow((Statement)stmt);
            }
        }
    }
}

