/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.pf4j.shell.InstrumentationAgent;

public class InstrumentationAgentFactory {
    private File agentFile;

    public File createAgentFile() throws IOException {
        if (this.agentFile == null) {
            String classPath = this.getClasspath();
            Manifest agentManifest = this.createAgentManifest(classPath);
            this.agentFile = File.createTempFile("agent", ".jar");
            this.agentFile.deleteOnExit();
            new JarOutputStream(Files.newOutputStream(this.agentFile.toPath(), new OpenOption[0]), agentManifest).close();
            System.out.println("Created agent jar " + this.agentFile.getCanonicalPath());
        }
        return this.agentFile;
    }

    private Manifest createAgentManifest(String classpath) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Agent-Class", InstrumentationAgent.class.getName());
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(Attributes.Name.CLASS_PATH, classpath);
        return manifest;
    }

    private String getClasspath() throws IOException {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringBuilder builder = new StringBuilder();
        for (String path : classpath.split(Pattern.quote(pathSeparator))) {
            String fileName;
            File file = new File(path);
            if (!file.exists()) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            if ((fileName = file.getCanonicalPath()).charAt(0) != '/' && fileName.charAt(1) == ':') {
                fileName = fileName.replace(File.separatorChar, '/');
                builder.append("/").append(fileName);
                continue;
            }
            builder.append(file.getCanonicalPath());
        }
        return builder.toString();
    }
}

