/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.fusesource.jansi.AnsiConsole;
import org.jline.builtins.ConfigurationPath;
import org.jline.console.CommandRegistry;
import org.jline.console.SystemRegistry;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.widget.TailTipWidgets;
import org.pf4j.PluginManager;
import org.pf4j.shell.DefaultCommandsProvider;
import org.pf4j.shell.ParentCommand;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

public class Shell {
    private final PluginManager pluginManager;
    private Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
    private String prompt = "pf4j-shell> ";
    private String rightPrompt;

    public Shell(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public Supplier<Path> getWorkDir() {
        return this.workDir;
    }

    public Shell setWorkDir(Supplier<Path> workDir) {
        this.workDir = workDir;
        return this;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Shell setPrompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    public String getRightPrompt() {
        return this.rightPrompt;
    }

    public Shell setRightPrompt(String rightPrompt) {
        this.rightPrompt = rightPrompt;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AnsiConsole.systemInstall();
        try {
            Builtins builtins = this.createBuiltins();
            ParentCommand parentCommand = new ParentCommand(this.pluginManager);
            PicocliCommands.PicocliCommandsFactory factory = this.createCommandsFactory();
            CommandLine commandLine = this.createCommandLine(parentCommand, factory);
            PicocliCommands picocliCommands = new PicocliCommands(commandLine);
            DefaultParser parser = new DefaultParser();
            try (Terminal terminal = TerminalBuilder.builder().build();){
                SystemRegistryImpl systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, this.getWorkDir(), null);
                systemRegistry.setCommandRegistries(new CommandRegistry[]{builtins, picocliCommands});
                systemRegistry.register("help", (CommandRegistry)picocliCommands);
                LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("list-max", (Object)50).build();
                builtins.setLineReader(reader);
                parentCommand.setReader(reader);
                factory.setTerminal(terminal);
                TailTipWidgets widgets = new TailTipWidgets(reader, arg_0 -> ((SystemRegistry)systemRegistry).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
                widgets.enable();
                KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
                keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
                this.processInput((SystemRegistry)systemRegistry, reader);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }

    protected CommandLine createCommandLine(ParentCommand parentCommand, PicocliCommands.PicocliCommandsFactory factory) {
        CommandLine commandLine = new CommandLine((Object)parentCommand, (CommandLine.IFactory)factory);
        DefaultCommandsProvider commandsProvider = new DefaultCommandsProvider();
        commandsProvider.getCommands().forEach(arg_0 -> ((CommandLine)commandLine).addSubcommand(arg_0));
        return commandLine;
    }

    protected PicocliCommands.PicocliCommandsFactory createCommandsFactory() {
        return new PicocliCommands.PicocliCommandsFactory();
    }

    protected Builtins createBuiltins() {
        ConfigurationPath configurationPath = new ConfigurationPath(null, null);
        Builtins builtins = new Builtins(this.getWorkDir(), configurationPath, null);
        builtins.rename((Enum)Builtins.Command.TTOP, "top");
        builtins.alias("zle", "widget");
        builtins.alias("bindkey", "keymap");
        return builtins;
    }

    private void processInput(SystemRegistry systemRegistry, LineReader reader) {
        while (true) {
            try {
                while (true) {
                    systemRegistry.cleanUp();
                    String line = reader.readLine(this.getPrompt(), this.getRightPrompt(), (MaskingCallback)null, null);
                    systemRegistry.execute(line);
                }
            }
            catch (UserInterruptException userInterruptException) {
                continue;
            }
            catch (EndOfFileException e) {
                return;
            }
            catch (Exception e) {
                systemRegistry.trace((Throwable)e);
                continue;
            }
            break;
        }
    }
}

