/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell.command;

import java.net.URL;
import java.util.List;
import java.util.Set;
import org.pf4j.PluginWrapper;
import org.pf4j.shell.command.AbstractCommand;
import org.pf4j.shell.util.ClassLoaderUtils;
import picocli.CommandLine;

@CommandLine.Command(name="classloader")
public class ClassLoaderCommand
extends AbstractCommand {
    @Override
    public void run() {
        this.info();
    }

    @CommandLine.Command(name="info", description={"Display information about classloaders"})
    public void info() {
        ClassLoaderUtils.getAllClassLoader(this.getInstrumentation()).forEach(System.out::println);
    }

    @CommandLine.Command(name="plugins", description={"Display information about plugins classloaders"})
    public void plugins() {
        List plugins = this.getPluginManager().getPlugins();
        for (PluginWrapper plugin : plugins) {
            System.out.printf("%s -> %s%n", plugin.getPluginId(), this.getPluginManager().getPluginClassLoader(plugin.getPluginId()));
        }
    }

    @CommandLine.Command(name="urls", description={"Display classloader urls"})
    public void urls(@CommandLine.Parameters String pluginId) {
        URL[] urls;
        ClassLoader classLoader = this.getPluginManager().getPluginClassLoader(pluginId);
        for (URL url : urls = ClassLoaderUtils.getUrls(classLoader)) {
            System.out.printf("%s%n", url);
        }
    }

    @CommandLine.Command
    public void loadedClasses(@CommandLine.Parameters String pluginId) {
        ClassLoader classLoader = this.getPluginManager().getPluginClassLoader(pluginId);
        Set<String> loadedClasses = ClassLoaderUtils.getLoadedClasses(classLoader, this.getInstrumentation());
        System.out.println(loadedClasses);
    }
}

