/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell.command;

import java.util.List;
import org.pf4j.PluginWrapper;
import org.pf4j.shell.command.AbstractCommand;
import org.pf4j.shell.util.ClassLoaderUtils;
import org.pf4j.shell.util.TextTable;
import picocli.CommandLine;

@CommandLine.Command(name="manager")
public class ManagerCommand
extends AbstractCommand {
    @Override
    public void run() {
        this.info();
    }

    @CommandLine.Command(name="info", description={"Display information about plugin manager"})
    public void info() {
        System.out.printf("Plugins roots: %s%n", this.getPluginManager().getPluginsRoots());
        System.out.printf("System version: %s%n", this.getPluginManager().getSystemVersion());
        System.out.printf("Runtime mode: %s%n", this.getPluginManager().getRuntimeMode());
    }

    @CommandLine.Command(name="unresolved", description={"Display unresolved"})
    public void unresolved() {
        List plugins = this.getPluginManager().getUnresolvedPlugins();
        TextTable<PluginWrapper> table = new TextTable<PluginWrapper>();
        table.addColumn("Id", PluginWrapper::getPluginId);
        table.addColumn("Version", ManagerCommand::getVersion);
        table.addColumn("State", PluginWrapper::getPluginState);
        System.out.println(table.createString(plugins));
    }

    @CommandLine.Command(name="extensions", description={"Display extensions for an extension point"})
    public void extensions() {
        List plugins = this.getPluginManager().getPlugins();
        for (PluginWrapper plugin : plugins) {
            System.out.printf("Plugin '%s': %s%n", plugin.getPluginId(), this.getPluginManager().getExtensionClassNames(plugin.getPluginId()));
        }
    }

    @CommandLine.Command(name="which", description={"Display the plugin that loaded the given class"})
    public void which(@CommandLine.Parameters String className) {
        Class<?> clazz = ClassLoaderUtils.getClass(className, this.getInstrumentation());
        if (clazz == null) {
            System.out.println("Class '" + className + "' not found");
            return;
        }
        PluginWrapper plugin = this.getPluginManager().whichPlugin(clazz);
        System.out.printf("Plugin %s%n", plugin.getPluginId());
    }

    private static String getVersion(PluginWrapper pluginWrapper) {
        return pluginWrapper.getDescriptor().getVersion();
    }
}

