/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell.command;

import java.nio.file.Path;
import org.pf4j.PluginWrapper;
import org.pf4j.shell.command.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="plugin")
public class PluginCommand
extends AbstractCommand {
    @CommandLine.Parameters(description={"The plugin identifier"})
    private String pluginId;

    @Override
    public void run() {
        this.info();
    }

    @CommandLine.Command(name="load", description={"Load plugin"})
    public void load(@CommandLine.Parameters Path pluginPath) {
        System.out.printf("Load plugin %s", this.pluginId);
        this.getPluginManager().loadPlugin(pluginPath);
    }

    @CommandLine.Command(name="unload", description={"Unload plugin"})
    public void unload() {
        System.out.printf("Unload plugin %s", this.pluginId);
        this.getPluginManager().unloadPlugin(this.pluginId);
    }

    @CommandLine.Command(name="start", description={"Start plugin"})
    public void start() {
        System.out.printf("Start plugin %s", this.pluginId);
        this.getPluginManager().startPlugin(this.pluginId);
    }

    @CommandLine.Command(name="stop", description={"Stop plugin"})
    public void stop() {
        System.out.printf("Stop plugin %s", this.pluginId);
        this.getPluginManager().stopPlugin(this.pluginId);
    }

    @CommandLine.Command(name="info", description={"Display information about plugin"})
    public void info() {
        PluginWrapper plugin = this.getPlugin();
        System.out.printf("Id : %s%n", plugin.getPluginId());
        System.out.printf("Version : %s%n", plugin.getDescriptor().getVersion());
        System.out.printf("State : %s\n", plugin.getPluginState());
        System.out.printf("Path : %s\n", plugin.getPluginPath());
        System.out.printf("PluginClass : %s\n", plugin.getDescriptor().getPluginClass());
        System.out.printf("Description : %s%n", plugin.getDescriptor().getPluginDescription());
        System.out.printf("Provider : %s\n", plugin.getDescriptor().getProvider());
        System.out.printf("License : %s\n", plugin.getDescriptor().getLicense());
        System.out.printf("Requires : %s\n", plugin.getDescriptor().getRequires());
        System.out.printf("Dependencies : %s\n", plugin.getDescriptor().getDependencies());
        System.out.printf("ClassLoader : %s\n", plugin.getPluginClassLoader());
    }

    private PluginWrapper getPlugin() {
        return this.getPluginManager().getPlugin(this.pluginId);
    }
}

