/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell.command;

import java.util.List;
import org.pf4j.PluginWrapper;
import org.pf4j.shell.command.AbstractCommand;
import org.pf4j.shell.util.TextTable;
import picocli.CommandLine;

@CommandLine.Command(name="plugins")
public class PluginsCommand
extends AbstractCommand {
    @Override
    public void run() {
        this.info();
    }

    @CommandLine.Command(name="load", description={"Load plugins"})
    public void load() {
        System.out.println("Load plugins ...");
        this.getPluginManager().loadPlugins();
    }

    @CommandLine.Command(name="reload", description={"Reload plugins"})
    public void reload() {
        System.out.println("Reload plugins ...");
        this.getPluginManager().unloadPlugins();
        this.getPluginManager().loadPlugins();
        this.getPluginManager().startPlugins();
    }

    @CommandLine.Command(name="unload", description={"Unload plugins"})
    public void unload() {
        System.out.println("Unload plugins ...");
        this.getPluginManager().unloadPlugins();
    }

    @CommandLine.Command(name="start", description={"Start plugins"})
    public void start() {
        System.out.println("Start plugins ...");
        this.getPluginManager().startPlugins();
    }

    @CommandLine.Command(name="stop", description={"Stop plugins"})
    public void stop() {
        System.out.println("Stop plugins ..");
        this.getPluginManager().stopPlugins();
    }

    @CommandLine.Command(name="info", description={"Display information about plugins"})
    public void info() {
        List plugins = this.getPluginManager().getPlugins();
        TextTable<PluginWrapper> table = new TextTable<PluginWrapper>();
        table.addColumn("Id", PluginWrapper::getPluginId);
        table.addColumn("Version", PluginsCommand::getVersion);
        table.addColumn("State", PluginWrapper::getPluginState);
        System.out.println(table.createString(plugins));
    }

    private static String getVersion(PluginWrapper pluginWrapper) {
        return pluginWrapper.getDescriptor().getVersion();
    }
}

