/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell.util;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static Set<ClassLoader> getAllClassLoader(Instrumentation instrumentation) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) continue;
            classLoaders.add(classLoader);
        }
        return classLoaders;
    }

    public static Set<String> getLoadedClasses(ClassLoader classLoader, Instrumentation instrumentation) {
        HashSet<String> loadedClasses = new HashSet<String>();
        try {
            Field field = ClassLoader.class.getDeclaredField("classes");
            field.setAccessible(true);
            loadedClasses.addAll((Vector)field.get(classLoader));
        }
        catch (Exception e) {
            for (Class clazz : instrumentation.getAllLoadedClasses()) {
                if (classLoader != clazz.getClassLoader()) continue;
                loadedClasses.add(clazz.getName());
            }
        }
        return loadedClasses;
    }

    public static URL[] getUrls(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        return new URL[0];
    }

    public static Class<?> getClass(String className, Instrumentation instrumentation) {
        Class[] loadedClasses;
        for (Class clazz : loadedClasses = instrumentation.getAllLoadedClasses()) {
            if (!clazz.getName().equals(className)) continue;
            return clazz;
        }
        return null;
    }
}

