/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.shell.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TextTable<T> {
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Function<? super T, String>> stringFunctions = new ArrayList<Function<? super T, String>>();

    public void addColumn(String columnName, Function<? super T, ?> fieldFunction) {
        this.columnNames.add(columnName);
        this.stringFunctions.add(p -> String.valueOf(fieldFunction.apply(p)));
    }

    public String createString(Iterable<? extends T> elements) {
        int c;
        List<Integer> columnWidths = this.computeColumnWidths(elements);
        StringBuilder sb = new StringBuilder();
        for (c = 0; c < this.columnNames.size(); ++c) {
            if (c > 0) {
                sb.append("|");
            }
            String format = "%" + columnWidths.get(c) + "s";
            sb.append(String.format(format, this.columnNames.get(c)));
        }
        sb.append("\n");
        for (c = 0; c < this.columnNames.size(); ++c) {
            if (c > 0) {
                sb.append("+");
            }
            sb.append(TextTable.padLeft("", '-', columnWidths.get(c)));
        }
        sb.append("\n");
        for (T element : elements) {
            for (int c2 = 0; c2 < this.columnNames.size(); ++c2) {
                if (c2 > 0) {
                    sb.append("|");
                }
                String format = "%" + columnWidths.get(c2) + "s";
                Function<T, String> f = this.stringFunctions.get(c2);
                String s = f.apply(element);
                sb.append(String.format(format, s));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private int computeMaxWidth(int column, Iterable<? extends T> elements) {
        int n = this.columnNames.get(column).length();
        Function<T, String> f = this.stringFunctions.get(column);
        for (T element : elements) {
            String s = f.apply(element);
            n = Math.max(n, s.length());
        }
        return n;
    }

    private static String padLeft(String s, char c, int length) {
        while (s.length() < length) {
            s = c + s;
        }
        return s;
    }

    private List<Integer> computeColumnWidths(Iterable<? extends T> elements) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (int c = 0; c < this.columnNames.size(); ++c) {
            columnWidths.add(this.computeMaxWidth(c, elements));
        }
        return columnWidths;
    }
}

