/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.modification.KeyRingEditor;
import org.pgpainless.key.modification.KeyRingEditorInterface;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.symmetric_encryption.SymmetricEncryptorDecryptor;
import org.pgpainless.util.Passphrase;

public class PGPainless {
    public static KeyRingBuilder generateKeyRing() {
        return new KeyRingBuilder();
    }

    public static KeyRingReader readKeyRing() {
        return new KeyRingReader();
    }

    public static EncryptionBuilder createEncryptor() {
        return new EncryptionBuilder();
    }

    public static DecryptionBuilder createDecryptor() {
        return new DecryptionBuilder();
    }

    public static KeyRingEditorInterface modifyKeyRing(PGPSecretKeyRing secretKeys) {
        return new KeyRingEditor(secretKeys);
    }

    public static byte[] encryptWithPassword(@Nonnull byte[] data, @Nonnull Passphrase password, @Nonnull SymmetricKeyAlgorithm algorithm) throws IOException, PGPException {
        return SymmetricEncryptorDecryptor.symmetricallyEncrypt(data, password, algorithm, CompressionAlgorithm.UNCOMPRESSED);
    }

    public static byte[] decryptWithPassword(@Nonnull byte[] data, @Nonnull Passphrase password) throws IOException, PGPException {
        return SymmetricEncryptorDecryptor.symmetricallyDecrypt(data, password);
    }
}

