/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.exception.SecretKeyNotFoundException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.selection.keyring.PublicKeyRingSelectionStrategy;
import org.pgpainless.key.selection.keyring.SecretKeyRingSelectionStrategy;
import org.pgpainless.util.MultiMap;

public interface EncryptionBuilderInterface {
    public ToRecipients onOutputStream(@Nonnull OutputStream var1);

    public static interface Armor {
        public EncryptionStream asciiArmor() throws IOException, PGPException;

        public EncryptionStream noArmor() throws IOException, PGPException;
    }

    public static interface SignWith {
        default public Armor signWith(PGPSecretKey ... keys) {
            return this.signWith((SecretKeyRingProtector)new UnprotectedKeysProtector(), keys);
        }

        public Armor signWith(@Nonnull SecretKeyRingProtector var1, PGPSecretKey ... var2);

        public Armor signWith(@Nonnull SecretKeyRingProtector var1, PGPSecretKeyRing ... var2);

        public <O> Armor signWith(@Nonnull SecretKeyRingSelectionStrategy<O> var1, @Nonnull SecretKeyRingProtector var2, @Nonnull MultiMap<O, PGPSecretKeyRingCollection> var3) throws SecretKeyNotFoundException;
    }

    public static interface DetachedSign
    extends SignWith {
        public SignWith createDetachedSignature();

        public Armor doNotSign();
    }

    public static interface WithAlgorithms {
        public WithAlgorithms andToSelf(PGPPublicKey ... var1);

        public WithAlgorithms andToSelf(PGPPublicKeyRing ... var1);

        public WithAlgorithms andToSelf(@Nonnull PGPPublicKeyRingCollection var1);

        public <O> WithAlgorithms andToSelf(@Nonnull PublicKeyRingSelectionStrategy<O> var1, @Nonnull MultiMap<O, PGPPublicKeyRingCollection> var2);

        public DetachedSign usingAlgorithms(@Nonnull SymmetricKeyAlgorithm var1, @Nonnull HashAlgorithm var2, @Nonnull CompressionAlgorithm var3);

        public DetachedSign usingSecureAlgorithms();
    }

    public static interface ToRecipients {
        public WithAlgorithms toRecipients(PGPPublicKey ... var1);

        public WithAlgorithms toRecipients(PGPPublicKeyRing ... var1);

        public WithAlgorithms toRecipients(PGPPublicKeyRingCollection ... var1);

        public <O> WithAlgorithms toRecipients(@Nonnull PublicKeyRingSelectionStrategy<O> var1, @Nonnull MultiMap<O, PGPPublicKeyRingCollection> var2);

        public DetachedSign doNotEncrypt();
    }
}

