/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.modification.KeyRingEditorInterface;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PassphraseMapKeyRingProtector;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;
import org.pgpainless.util.NotYetImplementedException;
import org.pgpainless.util.Passphrase;

public class KeyRingEditor
implements KeyRingEditorInterface {
    private PGPSecretKeyRing secretKeyRing;

    public KeyRingEditor(PGPSecretKeyRing secretKeyRing) {
        if (secretKeyRing == null) {
            throw new NullPointerException("SecretKeyRing MUST NOT be null.");
        }
        this.secretKeyRing = secretKeyRing;
    }

    @Override
    public KeyRingEditorInterface addUserId(String userId, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        userId = this.sanitizeUserId(userId);
        PGPDigestCalculator digestCalculator = new BcPGPDigestCalculatorProvider().get(HashAlgorithm.SHA1.getAlgorithmId());
        Iterator secretKeys = this.secretKeyRing.getSecretKeys();
        PGPSecretKey primarySecKey = (PGPSecretKey)secretKeys.next();
        PGPPrivateKey privateKey = this.unlockSecretKey(primarySecKey, secretKeyRingProtector);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)KeyRingEditor.getPgpContentSignerBuilderForKey(primarySecKey));
        signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
        PGPPublicKey primaryPubKey = this.secretKeyRing.getPublicKey();
        PGPSignature userIdSignature = signatureGenerator.generateCertification(userId, primaryPubKey);
        primaryPubKey = PGPPublicKey.addCertification((PGPPublicKey)primaryPubKey, (String)userId, (PGPSignature)userIdSignature);
        primarySecKey = new PGPSecretKey(privateKey, primaryPubKey, digestCalculator, true, secretKeyRingProtector.getEncryptor(primaryPubKey.getKeyID()));
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        secretKeyList.add(primarySecKey);
        while (secretKeys.hasNext()) {
            secretKeyList.add((PGPSecretKey)secretKeys.next());
        }
        this.secretKeyRing = new PGPSecretKeyRing(secretKeyList);
        return this;
    }

    private static BcPGPContentSignerBuilder getPgpContentSignerBuilderForKey(PGPSecretKey secretKey) {
        List<HashAlgorithm> preferredHashAlgorithms = OpenPgpKeyAttributeUtil.getPreferredHashAlgorithms(secretKey.getPublicKey());
        HashAlgorithm hashAlgorithm = KeyRingEditor.negotiateHashAlgorithm(preferredHashAlgorithms);
        return new BcPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), hashAlgorithm.getAlgorithmId());
    }

    private static HashAlgorithm negotiateHashAlgorithm(List<HashAlgorithm> preferredHashAlgorithms) {
        return preferredHashAlgorithms.get(0);
    }

    private PGPPrivateKey unlockSecretKey(PGPSecretKey secretKey, SecretKeyRingProtector protector) throws PGPException {
        PBESecretKeyDecryptor secretKeyDecryptor = protector.getDecryptor(secretKey.getKeyID());
        PGPPrivateKey privateKey = secretKey.extractPrivateKey(secretKeyDecryptor);
        return privateKey;
    }

    private String sanitizeUserId(String userId) {
        userId = userId.trim();
        return userId;
    }

    @Override
    public KeyRingEditorInterface deleteUserId(String userId, SecretKeyRingProtector protector) {
        throw new NotYetImplementedException();
    }

    @Override
    public KeyRingEditorInterface addSubKey(KeySpec keySpec, SecretKeyRingProtector protector) {
        throw new NotYetImplementedException();
    }

    @Override
    public KeyRingEditorInterface deleteSubKey(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector protector) {
        throw new NotYetImplementedException();
    }

    @Override
    public KeyRingEditorInterface deleteSubKey(long subKeyId, SecretKeyRingProtector protector) {
        throw new NotYetImplementedException();
    }

    @Override
    public KeyRingEditorInterface revokeSubKey(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector protector) {
        throw new NotYetImplementedException();
    }

    @Override
    public KeyRingEditorInterface revokeSubKey(long subKeyId, SecretKeyRingProtector protector) {
        throw new NotYetImplementedException();
    }

    @Override
    public KeyRingEditorInterface.WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(oldProtectionSettings, new SolitaryPassphraseProvider(oldPassphrase));
        return new WithKeyRingEncryptionSettingsImpl(null, protector);
    }

    @Override
    public KeyRingEditorInterface.WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long keyId, @Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        Map<Long, Passphrase> passphraseMap = Collections.singletonMap(keyId, oldPassphrase);
        PassphraseMapKeyRingProtector protector = new PassphraseMapKeyRingProtector(passphraseMap, oldProtectionSettings, null);
        return new WithKeyRingEncryptionSettingsImpl(keyId, protector);
    }

    @Override
    public PGPSecretKeyRing done() {
        return this.secretKeyRing;
    }

    private final class WithPassphraseImpl
    implements KeyRingEditorInterface.WithPassphrase {
        private final SecretKeyRingProtector oldProtector;
        private final KeyRingProtectionSettings newProtectionSettings;
        private final Long keyId;

        private WithPassphraseImpl(Long keyId, SecretKeyRingProtector oldProtector, KeyRingProtectionSettings newProtectionSettings) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
            this.newProtectionSettings = newProtectionSettings;
        }

        @Override
        public KeyRingEditorInterface toNewPassphrase(Passphrase passphrase) throws PGPException {
            PasswordBasedSecretKeyRingProtector newProtector = new PasswordBasedSecretKeyRingProtector(this.newProtectionSettings, new SolitaryPassphraseProvider(passphrase));
            PGPSecretKeyRing secretKeys = this.changePassphrase(this.keyId, KeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            KeyRingEditor.this.secretKeyRing = secretKeys;
            return KeyRingEditor.this;
        }

        @Override
        public KeyRingEditorInterface noPassphrase() throws PGPException {
            UnprotectedKeysProtector newProtector = new UnprotectedKeysProtector();
            PGPSecretKeyRing secretKeys = this.changePassphrase(this.keyId, KeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            KeyRingEditor.this.secretKeyRing = secretKeys;
            return KeyRingEditor.this;
        }

        private PGPSecretKeyRing changePassphrase(Long keyId, PGPSecretKeyRing secretKeys, SecretKeyRingProtector oldProtector, SecretKeyRingProtector newProtector) throws PGPException {
            if (keyId == null) {
                ArrayList<PGPSecretKey> newlyEncryptedSecretKeys = new ArrayList<PGPSecretKey>();
                Iterator secretKeyIterator = secretKeys.getSecretKeys();
                while (secretKeyIterator.hasNext()) {
                    PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                    PGPPrivateKey privateKey = KeyRingEditor.this.unlockSecretKey(secretKey, oldProtector);
                    secretKey = this.lockPrivateKey(privateKey, secretKey.getPublicKey(), newProtector);
                    newlyEncryptedSecretKeys.add(secretKey);
                }
                return new PGPSecretKeyRing(newlyEncryptedSecretKeys);
            }
            ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
            Iterator secretKeyIterator = secretKeys.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                if (secretKey.getPublicKey().getKeyID() == keyId.longValue()) {
                    PGPPrivateKey privateKey = KeyRingEditor.this.unlockSecretKey(secretKey, oldProtector);
                    secretKey = this.lockPrivateKey(privateKey, secretKey.getPublicKey(), newProtector);
                }
                secretKeyList.add(secretKey);
            }
            return new PGPSecretKeyRing(secretKeyList);
        }

        private PGPSecretKey lockPrivateKey(PGPPrivateKey privateKey, PGPPublicKey publicKey, SecretKeyRingProtector protector) throws PGPException {
            PGPDigestCalculator checksumCalculator = new BcPGPDigestCalculatorProvider().get(HashAlgorithm.SHA1.getAlgorithmId());
            PBESecretKeyEncryptor encryptor = protector.getEncryptor(publicKey.getKeyID());
            PGPSecretKey secretKey = new PGPSecretKey(privateKey, publicKey, checksumCalculator, publicKey.isMasterKey(), encryptor);
            return secretKey;
        }
    }

    private final class WithKeyRingEncryptionSettingsImpl
    implements KeyRingEditorInterface.WithKeyRingEncryptionSettings {
        private final Long keyId;
        private final SecretKeyRingProtector oldProtector;

        private WithKeyRingEncryptionSettingsImpl(Long keyId, SecretKeyRingProtector oldProtector) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
        }

        @Override
        public KeyRingEditorInterface.WithPassphrase withSecureDefaultSettings() {
            return this.withCustomSettings(KeyRingProtectionSettings.secureDefaultSettings());
        }

        @Override
        public KeyRingEditorInterface.WithPassphrase withCustomSettings(KeyRingProtectionSettings settings) {
            return new WithPassphraseImpl(this.keyId, this.oldProtector, settings);
        }
    }
}

