/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public interface KeyRingEditorInterface {
    public KeyRingEditorInterface addUserId(String var1, SecretKeyRingProtector var2) throws PGPException;

    public KeyRingEditorInterface deleteUserId(String var1, SecretKeyRingProtector var2);

    public KeyRingEditorInterface addSubKey(KeySpec var1, SecretKeyRingProtector var2);

    public KeyRingEditorInterface deleteSubKey(OpenPgpV4Fingerprint var1, SecretKeyRingProtector var2);

    public KeyRingEditorInterface deleteSubKey(long var1, SecretKeyRingProtector var3);

    public KeyRingEditorInterface revokeSubKey(OpenPgpV4Fingerprint var1, SecretKeyRingProtector var2);

    public KeyRingEditorInterface revokeSubKey(long var1, SecretKeyRingProtector var3);

    default public WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase oldPassphrase) {
        return this.changePassphraseFromOldPassphrase(oldPassphrase, KeyRingProtectionSettings.secureDefaultSettings());
    }

    public WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase var1, @Nonnull KeyRingProtectionSettings var2);

    default public WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long keyId, @Nullable Passphrase oldPassphrase) {
        return this.changeSubKeyPassphraseFromOldPassphrase(keyId, oldPassphrase, KeyRingProtectionSettings.secureDefaultSettings());
    }

    public WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long var1, @Nullable Passphrase var2, @Nonnull KeyRingProtectionSettings var3);

    public PGPSecretKeyRing done();

    public static interface WithPassphrase {
        public KeyRingEditorInterface toNewPassphrase(Passphrase var1) throws PGPException;

        public KeyRingEditorInterface noPassphrase() throws PGPException;
    }

    public static interface WithKeyRingEncryptionSettings {
        public WithPassphrase withSecureDefaultSettings();

        public WithPassphrase withCustomSettings(KeyRingProtectionSettings var1);
    }
}

