/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.parsing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.pgpainless.key.collection.PGPKeyRing;

public class KeyRingReader {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    @Nonnull
    public PGPPublicKeyRing publicKeyRing(@Nonnull InputStream inputStream) throws IOException {
        return KeyRingReader.readPublicKeyRing(inputStream);
    }

    public PGPPublicKeyRing publicKeyRing(@Nonnull byte[] bytes) throws IOException {
        return this.publicKeyRing(new ByteArrayInputStream(bytes));
    }

    public PGPPublicKeyRing publicKeyRing(@Nonnull String asciiArmored) throws IOException {
        return this.publicKeyRing(asciiArmored.getBytes(UTF8));
    }

    public PGPPublicKeyRingCollection publicKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return KeyRingReader.readPublicKeyRingCollection(inputStream);
    }

    public PGPPublicKeyRingCollection publicKeyRingCollection(@Nonnull byte[] bytes) throws IOException, PGPException {
        return this.publicKeyRingCollection(new ByteArrayInputStream(bytes));
    }

    public PGPPublicKeyRingCollection publicKeyRingCollection(@Nonnull String asciiArmored) throws IOException, PGPException {
        return this.publicKeyRingCollection(asciiArmored.getBytes(UTF8));
    }

    public PGPSecretKeyRing secretKeyRing(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return KeyRingReader.readSecretKeyRing(inputStream);
    }

    public PGPSecretKeyRing secretKeyRing(@Nonnull byte[] bytes) throws IOException, PGPException {
        return this.secretKeyRing(new ByteArrayInputStream(bytes));
    }

    public PGPSecretKeyRing secretKeyRing(@Nonnull String asciiArmored) throws IOException, PGPException {
        return this.secretKeyRing(asciiArmored.getBytes(UTF8));
    }

    public PGPSecretKeyRingCollection secretKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return KeyRingReader.readSecretKeyRingCollection(inputStream);
    }

    public PGPSecretKeyRingCollection secretKeyRingCollection(@Nonnull byte[] bytes) throws IOException, PGPException {
        return this.secretKeyRingCollection(new ByteArrayInputStream(bytes));
    }

    public PGPSecretKeyRingCollection secretKeyRingCollection(@Nonnull String asciiArmored) throws IOException, PGPException {
        return this.secretKeyRingCollection(asciiArmored.getBytes(UTF8));
    }

    public PGPKeyRing keyRing(@Nullable InputStream publicIn, @Nullable InputStream secretIn) throws IOException, PGPException {
        return KeyRingReader.readKeyRing(publicIn, secretIn);
    }

    public PGPKeyRing keyRing(@Nullable byte[] publicBytes, @Nullable byte[] secretBytes) throws IOException, PGPException {
        return this.keyRing(publicBytes != null ? new ByteArrayInputStream(publicBytes) : null, secretBytes != null ? new ByteArrayInputStream(secretBytes) : null);
    }

    public PGPKeyRing keyRing(@Nullable String asciiPublic, @Nullable String asciiSecret) throws IOException, PGPException {
        return this.keyRing(asciiPublic != null ? asciiPublic.getBytes(UTF8) : null, asciiSecret != null ? asciiSecret.getBytes(UTF8) : null);
    }

    public static PGPPublicKeyRing readPublicKeyRing(@Nonnull InputStream inputStream) throws IOException {
        return new PGPPublicKeyRing(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static PGPPublicKeyRingCollection readPublicKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static PGPSecretKeyRing readSecretKeyRing(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return new PGPSecretKeyRing(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static PGPSecretKeyRingCollection readSecretKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static PGPKeyRing readKeyRing(@Nullable InputStream publicIn, @Nullable InputStream secretIn) throws IOException, PGPException {
        KeyRingReader.validateStreamsNotBothNull(publicIn, secretIn);
        PGPPublicKeyRing publicKeys = KeyRingReader.maybeReadPublicKeys(publicIn);
        PGPSecretKeyRing secretKeys = KeyRingReader.maybeReadSecretKeys(secretIn);
        return KeyRingReader.asPGPKeyRing(publicKeys, secretKeys);
    }

    private static void validateStreamsNotBothNull(InputStream publicIn, InputStream secretIn) {
        if (publicIn == null && secretIn == null) {
            throw new NullPointerException("publicIn and secretIn cannot be BOTH null.");
        }
    }

    private static PGPPublicKeyRing maybeReadPublicKeys(InputStream publicIn) throws IOException {
        if (publicIn != null) {
            return KeyRingReader.readPublicKeyRing(publicIn);
        }
        return null;
    }

    private static PGPSecretKeyRing maybeReadSecretKeys(InputStream secretIn) throws IOException, PGPException {
        if (secretIn != null) {
            return KeyRingReader.readSecretKeyRing(secretIn);
        }
        return null;
    }

    private static PGPKeyRing asPGPKeyRing(PGPPublicKeyRing publicKeys, PGPSecretKeyRing secretKeys) {
        if (secretKeys == null) {
            return new PGPKeyRing(publicKeys);
        }
        if (publicKeys == null) {
            return new PGPKeyRing(secretKeys);
        }
        return new PGPKeyRing(publicKeys, secretKeys);
    }
}

