/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.key;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.pgpainless.key.selection.key.KeySelectionStrategy;
import org.pgpainless.util.MultiMap;

public abstract class PublicKeySelectionStrategy<O>
implements KeySelectionStrategy<PGPPublicKey, PGPPublicKeyRing, O> {
    @Override
    public Set<PGPPublicKey> selectKeysFromKeyRing(O identifier, @Nonnull PGPPublicKeyRing ring) {
        HashSet<PGPPublicKey> keys = new HashSet<PGPPublicKey>();
        Iterator i = ring.getPublicKeys();
        while (i.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)i.next();
            if (!this.accept(identifier, key)) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public MultiMap<O, PGPPublicKey> selectKeysFromKeyRings(@Nonnull MultiMap<O, PGPPublicKeyRing> keyRings) {
        MultiMap<O, PGPPublicKey> keys = new MultiMap<O, PGPPublicKey>();
        for (O identifier : keyRings.keySet()) {
            for (PGPPublicKeyRing ring : keyRings.get(identifier)) {
                keys.put(identifier, this.selectKeysFromKeyRing(identifier, ring));
            }
        }
        return keys;
    }
}

