/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.key.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.pgpainless.key.selection.key.PublicKeySelectionStrategy;

public class SignedByMasterKey {
    private static final Logger LOGGER = Logger.getLogger(SignedByMasterKey.class.getName());

    public static class PubkeySelectionStrategy
    extends PublicKeySelectionStrategy<PGPPublicKey> {
        @Override
        public boolean accept(PGPPublicKey masterKey, @Nonnull PGPPublicKey key) {
            if (Arrays.equals(masterKey.getFingerprint(), key.getFingerprint())) {
                return true;
            }
            Iterator signatures = key.getSignaturesForKeyID(masterKey.getKeyID());
            while (signatures.hasNext()) {
                PGPSignature signature = (PGPSignature)signatures.next();
                if (signature.getSignatureType() != 24) continue;
                try {
                    signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), masterKey);
                    return signature.verifyCertification(masterKey, key);
                }
                catch (PGPException e) {
                    LOGGER.log(Level.WARNING, "Could not verify subkey signature of key " + Long.toHexString(masterKey.getKeyID()) + " on key " + Long.toHexString(key.getKeyID()));
                    return false;
                }
            }
            return false;
        }
    }
}

