/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.exception.ModificationDetectionException;

public class IntegrityProtectedInputStream
extends InputStream {
    private final InputStream inputStream;
    private final PGPEncryptedData encryptedData;
    private final ConsumerOptions options;

    public IntegrityProtectedInputStream(InputStream inputStream, PGPEncryptedData encryptedData, ConsumerOptions options) {
        this.inputStream = inputStream;
        this.encryptedData = encryptedData;
        this.options = options;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(@Nonnull byte[] b, int offset, int length) throws IOException {
        return this.inputStream.read(b, offset, length);
    }

    @Override
    public void close() throws IOException {
        if (this.encryptedData.isIntegrityProtected() && !this.options.isIgnoreMDCErrors()) {
            try {
                if (!this.encryptedData.verify()) {
                    throw new ModificationDetectionException();
                }
            }
            catch (PGPException e) {
                throw new IOException("Failed to verify integrity protection", e);
            }
        }
    }
}

