/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.ArmorUtils;

public final class SignatureUtils {
    public static final int MAX_ITERATIONS = 10000;

    private SignatureUtils() {
    }

    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPSecretKey singingKey) {
        return SignatureUtils.getSignatureGeneratorFor(singingKey.getPublicKey());
    }

    public static PGPSignatureGenerator getSignatureGeneratorFor(PGPPublicKey signingPubKey) {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(SignatureUtils.getPgpContentSignerBuilderForKey(signingPubKey));
        return signatureGenerator;
    }

    public static PGPContentSignerBuilder getPgpContentSignerBuilderForKey(PGPPublicKey publicKey) {
        Set<HashAlgorithm> hashAlgorithmSet = OpenPgpKeyAttributeUtil.getOrGuessPreferredHashAlgorithms(publicKey);
        HashAlgorithm hashAlgorithm = HashAlgorithmNegotiator.negotiateSignatureHashAlgorithm(PGPainless.getPolicy()).negotiateHashAlgorithm(hashAlgorithmSet);
        return ImplementationFactory.getInstance().getPGPContentSignerBuilder(publicKey.getAlgorithm(), hashAlgorithm.getAlgorithmId());
    }

    public static Date getKeyExpirationDate(Date keyCreationDate, PGPSignature signature) {
        KeyExpirationTime keyExpirationTime = SignatureSubpacketsUtil.getKeyExpirationTime(signature);
        long expiresInSecs = keyExpirationTime == null ? 0L : keyExpirationTime.getTime();
        return SignatureUtils.datePlusSeconds(keyCreationDate, expiresInSecs);
    }

    public static Date getSignatureExpirationDate(PGPSignature signature) {
        Date creationDate = signature.getCreationTime();
        SignatureExpirationTime signatureExpirationTime = SignatureSubpacketsUtil.getSignatureExpirationTime(signature);
        long expiresInSecs = signatureExpirationTime == null ? 0L : signatureExpirationTime.getTime();
        return SignatureUtils.datePlusSeconds(creationDate, expiresInSecs);
    }

    public static Date datePlusSeconds(Date date, long seconds) {
        if (seconds == 0L) {
            return null;
        }
        return new Date(date.getTime() + 1000L * seconds);
    }

    public static boolean isSignatureExpired(PGPSignature signature) {
        return SignatureUtils.isSignatureExpired(signature, new Date());
    }

    public static boolean isSignatureExpired(PGPSignature signature, Date comparisonDate) {
        Date expirationDate = SignatureUtils.getSignatureExpirationDate(signature);
        return expirationDate != null && comparisonDate.after(expirationDate);
    }

    public static boolean isHardRevocation(PGPSignature signature) {
        SignatureType type = SignatureType.valueOf(signature.getSignatureType());
        if (type != SignatureType.KEY_REVOCATION && type != SignatureType.SUBKEY_REVOCATION && type != SignatureType.CERTIFICATION_REVOCATION) {
            return false;
        }
        RevocationReason reasonSubpacket = SignatureSubpacketsUtil.getRevocationReason(signature);
        if (reasonSubpacket == null) {
            return true;
        }
        return RevocationAttributes.Reason.isHardRevocation(reasonSubpacket.getRevocationReason());
    }

    public static List<PGPSignature> readSignatures(String encodedSignatures) throws IOException, PGPException {
        Charset utf8 = Charset.forName("UTF-8");
        byte[] bytes = encodedSignatures.getBytes(utf8);
        return SignatureUtils.readSignatures(bytes);
    }

    public static List<PGPSignature> readSignatures(byte[] encodedSignatures) throws IOException, PGPException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(encodedSignatures);
        return SignatureUtils.readSignatures(inputStream);
    }

    public static List<PGPSignature> readSignatures(InputStream inputStream) throws IOException, PGPException {
        return SignatureUtils.readSignatures(inputStream, 10000);
    }

    public static List<PGPSignature> readSignatures(InputStream inputStream, int maxIterations) throws IOException, PGPException {
        Object nextObject;
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        InputStream pgpIn = ArmorUtils.getDecoderStream(inputStream);
        PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(pgpIn);
        int i = 0;
        while (i++ < maxIterations && (nextObject = objectFactory.nextObject()) != null) {
            if (nextObject instanceof PGPCompressedData) {
                PGPCompressedData compressedData = (PGPCompressedData)nextObject;
                Streams.drain((InputStream)compressedData.getInputStream());
            }
            if (nextObject instanceof PGPSignatureList) {
                PGPSignatureList signatureList = (PGPSignatureList)nextObject;
                for (PGPSignature s : signatureList) {
                    signatures.add(s);
                }
            }
            if (!(nextObject instanceof PGPSignature)) continue;
            signatures.add((PGPSignature)nextObject);
        }
        pgpIn.close();
        return signatures;
    }

    public static long determineIssuerKeyId(PGPSignature signature) {
        if (signature.getVersion() == 3) {
            return signature.getKeyID();
        }
        IssuerKeyID issuerKeyId = SignatureSubpacketsUtil.getIssuerKeyId(signature);
        OpenPgpFingerprint fingerprint = SignatureSubpacketsUtil.getIssuerFingerprintAsOpenPgpFingerprint(signature);
        if (issuerKeyId != null && issuerKeyId.getKeyID() != 0L) {
            return issuerKeyId.getKeyID();
        }
        if (issuerKeyId == null && fingerprint != null) {
            return fingerprint.getKeyId();
        }
        return 0L;
    }

    public static String getSignatureDigestPrefix(PGPSignature signature) {
        return Hex.toHexString((byte[])signature.getDigestPrefix());
    }

    public static List<PGPSignature> toList(PGPSignatureList signatures) {
        ArrayList<PGPSignature> list = new ArrayList<PGPSignature>();
        for (PGPSignature signature : signatures) {
            list.add(signature);
        }
        return list;
    }

    public static boolean wasIssuedBy(byte[] fingerprint, PGPSignature signature) {
        try {
            OpenPgpFingerprint fp = OpenPgpFingerprint.parseFromBinary(fingerprint);
            OpenPgpFingerprint issuerFp = SignatureSubpacketsUtil.getIssuerFingerprintAsOpenPgpFingerprint(signature);
            if (issuerFp == null) {
                return fp.getKeyId() == signature.getKeyID();
            }
            return fp.equals(issuerFp);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Nonnull
    public static List<PGPSignature> getSignaturesOverUserIdBy(@Nonnull PGPPublicKey key, @Nonnull String userId, long issuerKeyId) {
        ArrayList<PGPSignature> signaturesByKeyId = new ArrayList<PGPSignature>();
        Iterator userIdSignatures = key.getSignaturesForID(userId);
        if (userIdSignatures == null) {
            return signaturesByKeyId;
        }
        while (userIdSignatures.hasNext()) {
            PGPSignature signature = (PGPSignature)userIdSignatures.next();
            if (signature.getKeyID() != issuerKeyId) continue;
            signaturesByKeyId.add(signature);
        }
        return Collections.unmodifiableList(signaturesByKeyId);
    }
}

