/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli;

import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import sop.cli.picocli.DateParser;
import sop.util.UTCUtil;

public class DateParserTest {
    @Test
    public void parseNotAfterDashReturnsEndOfTime() {
        Assertions.assertEquals((Object)DateParser.END_OF_TIME, (Object)DateParser.parseNotAfter((String)"-"));
    }

    @Test
    public void parseNotBeforeDashReturnsBeginningOfTime() {
        Assertions.assertEquals((Object)DateParser.BEGINNING_OF_TIME, (Object)DateParser.parseNotBefore((String)"-"));
    }

    @Test
    public void parseNotAfterNowReturnsNow() {
        Assertions.assertEquals((float)new Date().getTime(), (float)DateParser.parseNotAfter((String)"now").getTime(), (float)1000.0f);
    }

    @Test
    public void parseNotBeforeNowReturnsNow() {
        Assertions.assertEquals((float)new Date().getTime(), (float)DateParser.parseNotBefore((String)"now").getTime(), (float)1000.0f);
    }

    @Test
    public void parseNotAfterTimestamp() {
        String timestamp = "2019-10-24T23:48:29Z";
        Date date = DateParser.parseNotAfter((String)timestamp);
        Assertions.assertEquals((Object)timestamp, (Object)UTCUtil.formatUTCDate((Date)date));
    }

    @Test
    public void parseNotBeforeTimestamp() {
        String timestamp = "2019-10-29T18:36:45Z";
        Date date = DateParser.parseNotBefore((String)timestamp);
        Assertions.assertEquals((Object)timestamp, (Object)UTCUtil.formatUTCDate((Date)date));
    }
}

